/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddCanvasConnectorCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;

public class DeleteCanvasConnectorCommand
extends AbstractCanvasCommand {
    private final Edge candidate;
    private final Node source;
    private final Node target;

    public DeleteCanvasConnectorCommand(Edge candidate) {
        this.candidate = candidate;
        this.source = candidate.getSourceNode();
        this.target = candidate.getTargetNode();
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        context.deregister((Element)this.candidate);
        if (null != this.source) {
            context.notifyCanvasElementUpdated((Element)this.source);
        }
        if (null != this.target) {
            context.notifyCanvasElementUpdated((Element)this.target);
        }
        return this.buildResult();
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        String ssid = context.getDiagram().getMetadata().getShapeSetId();
        return new AddCanvasConnectorCommand(this.candidate, ssid).execute(context);
    }

    public Edge getCandidate() {
        return this.candidate;
    }

    public String toString() {
        return this.getClass().getName() + " [candidate=" + this.getUUID((Element<?>)this.candidate) + ", sourceNode=" + this.getUUID((Element<?>)this.source) + ", targetNode=" + this.getUUID((Element<?>)this.target) + "]";
    }
}

