/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DeleteCanvasConnectorCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DeleteCanvasNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.RemoveCanvasChildCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.SetCanvasConnectionCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CompositeCommand;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommandImpl;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.impl.SafeDeleteNodeCommand;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

public class DeleteNodeCommand
extends AbstractCanvasGraphCommand {
    private static Logger LOGGER = Logger.getLogger(DeleteNodeCommand.class.getName());
    private final Node candidate;
    private transient CompositeCommand<AbstractCanvasHandler, CanvasViolation> command;

    public DeleteNodeCommand(Node candidate) {
        this.candidate = candidate;
        this.command = new CompositeCommandImpl.CompositeCommandBuilder().reverse().build();
    }

    public Node getCandidate() {
        return this.candidate;
    }

    @Override
    protected Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler context) {
        return new SafeDeleteNodeCommand(this.candidate, (SafeDeleteNodeCommand.SafeDeleteNodeCommandCallback)new CanvasDeleteProcessor());
    }

    @Override
    protected Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler context) {
        return this.command;
    }

    protected CompositeCommand<AbstractCanvasHandler, CanvasViolation> getCommand() {
        return this.command;
    }

    private void log(String message) {
        LOGGER.log(Level.FINE, message);
    }

    private class CanvasDeleteProcessor
    implements SafeDeleteNodeCommand.SafeDeleteNodeCommandCallback {
        private CanvasDeleteProcessor() {
        }

        public void deleteCandidateConnector(Edge<? extends View<?>, Node> connector) {
            this.doDeleteConnector(connector);
        }

        public void deleteConnector(Edge<? extends View<?>, Node> connector) {
            this.doDeleteConnector(connector);
        }

        public void setEdgeTargetNode(Node<?, Edge> targetNode, Edge<? extends View<?>, Node> candidate) {
            DeleteNodeCommand.this.log("SetCanvasConnectionCommand [candidate=" + candidate.getUUID() + "]");
            DeleteNodeCommand.this.getCommand().addCommand((Command)new SetCanvasConnectionCommand(candidate));
        }

        public void removeChild(Element<?> parent, Node<?, Edge> candidate) {
            DeleteNodeCommand.this.log("RemoveCanvasChildCommand [parent=" + parent.getUUID() + ", candidate=" + candidate.getUUID() + "]");
            DeleteNodeCommand.this.getCommand().addCommand((Command)new RemoveCanvasChildCommand((Node)parent, candidate));
        }

        public void removeDock(Node<?, Edge> parent, Node<?, Edge> candidate) {
        }

        public void deleteCandidateNode(Node<?, Edge> node) {
            this.doDeleteNode(node);
        }

        public void deleteNode(Node<?, Edge> node) {
            this.doDeleteNode(node);
        }

        private void doDeleteNode(Node<?, Edge> node) {
            DeleteNodeCommand.this.log("DeleteCanvasNodeCommand [node=" + node.getUUID() + "]");
            DeleteNodeCommand.this.getCommand().addCommand((Command)new DeleteCanvasNodeCommand(node));
        }

        private void doDeleteConnector(Edge<? extends View<?>, Node> connector) {
            DeleteNodeCommand.this.log("DeleteCanvasConnectorCommand [connector=" + connector.getUUID() + "]");
            DeleteNodeCommand.this.getCommand().addCommand((Command)new DeleteCanvasConnectorCommand(connector));
        }
    }
}

