/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddCanvasChildNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddCanvasConnectorCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddCanvasDockedNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddCanvasNodeCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommandImpl;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Dock;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.AbstractChildrenTraverseCallback;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.AbstractContentTraverseCallback;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.ChildrenTraverseProcessor;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.ViewTraverseProcessor;

public class DrawCanvasCommand
extends AbstractCanvasCommand {
    private final ChildrenTraverseProcessor childrenTraverseProcessor;
    private final ViewTraverseProcessor viewTraverseProcessor;

    public DrawCanvasCommand(ChildrenTraverseProcessor childrenTraverseProcessor, ViewTraverseProcessor viewTraverseProcessor) {
        this.childrenTraverseProcessor = childrenTraverseProcessor;
        this.viewTraverseProcessor = viewTraverseProcessor;
    }

    public CommandResult<CanvasViolation> execute(final AbstractCanvasHandler context) {
        Graph graph = context.getGraphIndex().getGraph();
        final String shapeSetId = this.getShapeSetId(context);
        final CompositeCommandImpl.CompositeCommandBuilder commandBuilder = new CompositeCommandImpl.CompositeCommandBuilder().forward();
        this.childrenTraverseProcessor.traverse((Object)graph, (Object)new AbstractChildrenTraverseCallback<Node<View, Edge>, Edge<Child, Node>>(){

            public void startNodeTraversal(Node<View, Edge> node) {
                super.startNodeTraversal(node);
                if (!DrawCanvasCommand.this.isCanvasRoot().test(context, node.getUUID())) {
                    this.addNode(node);
                }
            }

            public boolean startNodeTraversal(List<Node<View, Edge>> parents, Node<View, Edge> node) {
                super.startNodeTraversal(parents, node);
                Optional<Edge> dockEdge = node.getInEdges().stream().filter(e -> e.getContent() instanceof Dock).findAny();
                Node parent = dockEdge.map(Edge::getSourceNode).orElseGet(() -> (Node)parents.get(parents.size() - 1));
                if (dockEdge.isPresent()) {
                    this.addDockedNode((Node<View, Edge>)parent, node);
                } else if (DrawCanvasCommand.this.isCanvasRoot().test(context, parent.getUUID())) {
                    this.addNode(node);
                } else {
                    this.addChildNode((Node<View, Edge>)parent, node);
                }
                return true;
            }

            private void addNode(Node<View, Edge> node) {
                commandBuilder.addCommand((Command)new AddCanvasNodeCommand(node, shapeSetId));
            }

            private void addChildNode(Node<View, Edge> parent, Node<View, Edge> node) {
                commandBuilder.addCommand((Command)new AddCanvasChildNodeCommand(parent, node, shapeSetId));
            }

            private void addDockedNode(Node<View, Edge> parent, Node<View, Edge> node) {
                commandBuilder.addCommand((Command)new AddCanvasDockedNodeCommand(parent, node, shapeSetId));
            }
        });
        this.viewTraverseProcessor.traverse((Object)graph, (Object)new AbstractContentTraverseCallback<View<?>, Node<View, Edge>, Edge<View<?>, Node>>(){

            public void startEdgeTraversal(Edge<View<?>, Node> edge) {
                super.startEdgeTraversal(edge);
                commandBuilder.addCommand((Command)new AddCanvasConnectorCommand(edge, shapeSetId));
            }
        });
        return commandBuilder.build().execute((Object)context);
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        throw new UnsupportedOperationException("Undo operation for [" + this.getClass().getName() + "[ is not supported..");
    }

    private BiPredicate<AbstractCanvasHandler, String> isCanvasRoot() {
        return (handler, uuid) -> this.getCanvasRootUUID((AbstractCanvasHandler)handler).map(s -> s.equals(uuid)).orElse(false);
    }

    private Optional<String> getCanvasRootUUID(AbstractCanvasHandler context) {
        return Optional.ofNullable(context.getDiagram().getMetadata().getCanvasRootUUID());
    }

    private String getShapeSetId(AbstractCanvasHandler context) {
        return context.getDiagram().getMetadata().getShapeSetId();
    }
}

