/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import java.util.List;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.shape.EdgeShape;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.definition.morph.MorphDefinition;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Dock;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class MorphCanvasNodeCommand
extends AbstractCanvasCommand {
    private Node<? extends Definition<?>, Edge> candidate;
    private MorphDefinition morphDefinition;
    private String shapeSetId;

    public MorphCanvasNodeCommand(Node<? extends Definition<?>, Edge> candidate, MorphDefinition morphDefinition, String shapeSetId) {
        this.candidate = candidate;
        this.morphDefinition = morphDefinition;
        this.shapeSetId = shapeSetId;
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        List outEdges;
        Node parent = this.getParent();
        if (null != parent) {
            context.removeChild((Element)parent, (Element)this.candidate);
        }
        context.deregister((Element)this.candidate);
        context.register(this.shapeSetId, (Element<View<?>>)this.candidate);
        if (null != parent) {
            context.addChild((Element)parent, (Element)this.candidate);
        }
        context.applyElementMutation((Element)this.candidate, MutationContext.STATIC);
        List inEdges = this.candidate.getInEdges();
        if (null != inEdges && !inEdges.isEmpty()) {
            for (Edge inEdge : inEdges) {
                if (!this.isViewEdge(inEdge)) continue;
                Node inNode = inEdge.getSourceNode();
                this.updateConnections(context, inEdge, inNode, this.candidate);
            }
        }
        if (null != (outEdges = this.candidate.getOutEdges()) && !outEdges.isEmpty()) {
            for (Edge outEdge : outEdges) {
                if (!this.isViewEdge(outEdge)) continue;
                Node targetNode = outEdge.getTargetNode();
                this.updateConnections(context, outEdge, this.candidate, targetNode);
            }
        }
        return this.buildResult();
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        return this.execute(context);
    }

    private void updateConnections(AbstractCanvasHandler context, Edge edge, Node sourceNode, Node targetNode) {
        if (null != edge && null != sourceNode && null != targetNode) {
            EdgeShape edgeShape = (EdgeShape)context.getCanvas().getShape(edge.getUUID());
            Shape sourceNodeShape = context.getCanvas().getShape(sourceNode.getUUID());
            Shape targetNodeShape = context.getCanvas().getShape(targetNode.getUUID());
            edgeShape.applyConnections(edge, sourceNodeShape.getShapeView(), targetNodeShape.getShapeView(), MutationContext.STATIC);
        }
    }

    private Node getParent() {
        List inEdges = this.candidate.getInEdges();
        if (null != inEdges && !inEdges.isEmpty()) {
            for (Edge edge : inEdges) {
                if (!this.isChildEdge(edge) && !this.isDockEdge(edge)) continue;
                return edge.getSourceNode();
            }
        }
        return null;
    }

    private boolean isChildEdge(Edge edge) {
        return edge.getContent() instanceof Child;
    }

    private boolean isDockEdge(Edge edge) {
        return edge.getContent() instanceof Dock;
    }

    private boolean isViewEdge(Edge edge) {
        return edge.getContent() instanceof View;
    }

    public String toString() {
        Node parent = this.getParent();
        return this.getClass().getName() + " [parent=" + (null != parent ? parent.getUUID() : "null") + ", candidate=" + this.getUUID((Element<?>)this.candidate) + ", shapeSet=" + this.shapeSetId + "]";
    }
}

