/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.RemoveCanvasChildCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.util.ShapeUtils;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Dock;

public class SetCanvasChildNodeCommand
extends AbstractCanvasCommand {
    private final Node parent;
    private final Node candidate;

    public SetCanvasChildNodeCommand(Node parent, Node candidate) {
        this.parent = parent;
        this.candidate = candidate;
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        if (!SetCanvasChildNodeCommand.isDocked(this.candidate)) {
            context.addChild((Element)this.parent, (Element)this.candidate);
            context.applyElementMutation((Element)this.parent, MutationContext.STATIC);
            context.applyElementMutation((Element)this.candidate, MutationContext.STATIC);
            ShapeUtils.moveViewConnectorsToTop(context, this.candidate);
        }
        return this.buildResult();
    }

    private static boolean isDocked(Node<?, Edge> candidate) {
        return candidate.getInEdges().stream().filter(e -> e.getContent() instanceof Dock).findAny().isPresent();
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        return new RemoveCanvasChildCommand(this.parent, this.candidate).execute(context);
    }

    public Node getParent() {
        return this.parent;
    }

    public Node getCandidate() {
        return this.candidate;
    }

    public String toString() {
        return this.getClass().getName() + " [parent=" + this.getUUID((Element<?>)this.parent) + ", candidate=" + this.getUUID((Element<?>)this.candidate) + "]";
    }
}

