/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCompositeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DockNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.RemoveChildCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.SetChildNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.UnDockNodeCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.impl.AbstractCompositeCommand;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Dock;

public class UpdateChildNodeCommand
extends AbstractCanvasCompositeCommand {
    private final Node parent;
    private final Node candidate;

    public UpdateChildNodeCommand(Node parent, Node candidate) {
        this.parent = parent;
        this.candidate = candidate;
    }

    protected AbstractCompositeCommand<AbstractCanvasHandler, CanvasViolation> initialize(AbstractCanvasHandler context) {
        super.initialize((Object)context);
        List candidateInEdges = this.candidate.getInEdges();
        List candidateOutEdges = this.candidate.getOutEdges();
        Optional<Edge> currentParentEdge = candidateInEdges.stream().filter(this.isDifferentParent()).findAny();
        Optional<Edge> currentDockEdge = candidateInEdges.stream().filter(e -> e.getContent() instanceof Dock).findAny();
        Set<Edge> dockedParentEdges = candidateOutEdges.stream().filter(e -> e.getContent() instanceof Dock).map(Edge::getTargetNode).flatMap(node -> node.getInEdges().stream()).filter(this.isDifferentParent()).collect(Collectors.toSet());
        currentDockEdge.ifPresent(e -> this.addCommand((Command)new UnDockNodeCommand(e.getSourceNode(), this.candidate)));
        currentParentEdge.ifPresent(e -> this.addCommand((Command)new RemoveChildCommand(e.getSourceNode(), this.candidate)));
        dockedParentEdges.forEach(e -> this.addCommand((Command)new RemoveChildCommand(e.getSourceNode(), e.getTargetNode())).addCommand((Command)new UnDockNodeCommand(this.candidate, e.getTargetNode())));
        currentParentEdge.ifPresent(e -> this.addCommand((Command)new SetChildNodeCommand(this.parent, this.candidate)));
        dockedParentEdges.forEach(e -> this.addCommand((Command)new SetChildNodeCommand(this.parent, e.getTargetNode())).addCommand((Command)new DockNodeCommand(this.candidate, e.getTargetNode())));
        return this;
    }

    private Predicate<Edge> isDifferentParent() {
        return e -> e.getContent() instanceof Child && !this.parent.equals(e.getSourceNode());
    }

    public Node getParent() {
        return this.parent;
    }

    public Node getCandidate() {
        return this.candidate;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + " [parent=" + this.getUUID((Element<?>)this.parent) + " [candidate=" + this.getUUID((Element<?>)this.candidate) + " {" + super.toString() + "}";
    }
}

