/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCompositeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DockNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.RemoveChildCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.SetChildNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.UnDockNodeCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.impl.AbstractCompositeCommand;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Dock;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;

public class UpdateDockNodeCommand
extends AbstractCanvasCompositeCommand {
    private final Node parent;
    private final Node candidate;

    public UpdateDockNodeCommand(Node parent, Node candidate) {
        this.parent = parent;
        this.candidate = candidate;
    }

    protected AbstractCompositeCommand<AbstractCanvasHandler, CanvasViolation> initialize(AbstractCanvasHandler context) {
        boolean mustUpdateParent;
        super.initialize((Object)context);
        Optional<Edge<?, Node>> dockEdge = this.getEdge(this.candidate.getInEdges(), e -> e.getContent() instanceof Dock);
        Optional<Edge<?, Node>> childEdge = this.getEdge(this.candidate.getInEdges(), e -> e.getContent() instanceof Child);
        Element parentParent = GraphUtils.getParent((Node)this.parent);
        boolean bl = mustUpdateParent = null != parentParent && childEdge.filter(e -> !parentParent.equals(e.getSourceNode())).isPresent();
        if (mustUpdateParent) {
            this.addCommand((Command)new RemoveChildCommand(childEdge.get().getSourceNode(), this.candidate));
        }
        dockEdge.ifPresent(e -> this.addCommand((Command)new UnDockNodeCommand(e.getSourceNode(), this.candidate)));
        if (mustUpdateParent) {
            this.addCommand((Command)new SetChildNodeCommand((Node)parentParent, this.candidate));
        }
        this.addCommand((Command)new DockNodeCommand(this.parent, this.candidate));
        return this;
    }

    protected Optional<Edge<?, Node>> getEdge(List<Edge<?, Node>> edges, Predicate<Edge> predicate) {
        if (null != edges) {
            return edges.stream().filter(predicate).findAny();
        }
        return Optional.empty();
    }

    public Node getParent() {
        return this.parent;
    }

    public Node getCandidate() {
        return this.candidate;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + " [parent=" + this.getUUID((Element<?>)this.parent) + " [candidate=" + this.getUUID((Element<?>)this.candidate) + " {" + super.toString() + "}";
    }
}

