/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls;

import java.util.HashMap;
import java.util.Map;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasRegistationControl;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.HasEventHandlers;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;

public abstract class AbstractCanvasRegistrationControl<C extends AbstractCanvas>
extends AbstractCanvasControl<C>
implements CanvasRegistationControl<C, Shape> {
    private final Map<String, ViewHandler<?>> handlers = new HashMap();

    protected void registerHandler(String uuid, ViewHandler<?> handler) {
        this.handlers.put(uuid, handler);
    }

    @Override
    protected void doDisable() {
        for (Map.Entry<String, ViewHandler<?>> entry : this.handlers.entrySet()) {
            String uuid = entry.getKey();
            Shape shape = this.canvas.getShape(uuid);
            ViewHandler<?> handler = entry.getValue();
            this.doDeregister(shape, handler);
        }
    }

    public void deregister(Shape shape) {
        if (null != shape) {
            ViewHandler<?> handler = this.handlers.get(shape.getUUID());
            this.doDeregister(shape, handler);
        }
    }

    protected void doDeregister(Shape shape, ViewHandler<?> handler) {
        if (null != handler) {
            HasEventHandlers hasEventHandlers = (HasEventHandlers)shape.getShapeView();
            hasEventHandlers.removeHandler(handler);
        }
    }
}

