/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.actions;

import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerRegistrationControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.CanvasInPlaceTextEditorControl;
import org.kie.workbench.common.stunner.core.client.canvas.event.CanvasFocusedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasElementSelectedEvent;
import org.kie.workbench.common.stunner.core.client.command.RequiresCommandManager;
import org.kie.workbench.common.stunner.core.client.components.actions.TextEditorBox;
import org.kie.workbench.common.stunner.core.client.components.views.FloatingView;
import org.kie.workbench.common.stunner.core.client.event.keyboard.KeyDownEvent;
import org.kie.workbench.common.stunner.core.client.event.keyboard.KeyboardEvent;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.HasEventHandlers;
import org.kie.workbench.common.stunner.core.client.shape.view.HasTitle;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextDoubleClickEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextDoubleClickHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextEnterEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextEnterHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextExitEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextExitHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.mvp.Command;

@Dependent
public class CanvasInPlaceTextEditorControlImpl
extends AbstractCanvasHandlerRegistrationControl<AbstractCanvasHandler>
implements CanvasInPlaceTextEditorControl<AbstractCanvasHandler, Element> {
    private static final int FLOATING_VIEW_TIMEOUT = 3000;
    private static final double SHAPE_EDIT_ALPHA = 0.2;
    private final FloatingView<IsWidget> floatingView;
    private final TextEditorBox<AbstractCanvasHandler, Element> textEditorBox;
    private final Event<CanvasElementSelectedEvent> elementSelectedEvent;
    private String uuid;
    private final Command floatingHideCallback = this::hide;

    @Inject
    public CanvasInPlaceTextEditorControlImpl(FloatingView<IsWidget> floatingView, TextEditorBox<AbstractCanvasHandler, Element> textEditorBox, Event<CanvasElementSelectedEvent> elementSelectedEvent) {
        this.floatingView = floatingView;
        this.textEditorBox = textEditorBox;
        this.elementSelectedEvent = elementSelectedEvent;
        this.uuid = null;
    }

    @Override
    public void enable(AbstractCanvasHandler canvasHandler) {
        super.enable(canvasHandler);
        this.textEditorBox.initialize((CanvasHandler)canvasHandler, () -> {
            String idToSelect = this.uuid;
            this.hide();
            this.elementSelectedEvent.fire((Object)new CanvasElementSelectedEvent((CanvasHandler)canvasHandler, idToSelect));
        });
        this.floatingView.hide().setHideCallback(this.floatingHideCallback).setTimeOut(3000).add((Object)ElementWrapperWidget.getWidget((HTMLElement)this.textEditorBox.getElement()));
    }

    public void register(final Element element) {
        HasEventHandlers hasEventHandlers;
        ShapeView shapeView;
        Shape<?> shape;
        if (this.checkNotRegistered(element) && null != (shape = this.getShape(element.getUUID())) && (shapeView = shape.getShapeView()) instanceof HasEventHandlers && (hasEventHandlers = (HasEventHandlers)shapeView).supports(ViewEventType.TEXT_DBL_CLICK)) {
            TextDoubleClickHandler clickHandler = new TextDoubleClickHandler(){

                public void handle(TextDoubleClickEvent event) {
                    CanvasInPlaceTextEditorControlImpl.this.show(element, event.getClientX(), event.getClientY());
                }
            };
            hasEventHandlers.addHandler(ViewEventType.TEXT_DBL_CLICK, (ViewHandler)clickHandler);
            this.registerHandler(shape.getUUID(), (ViewHandler<?>)clickHandler);
            if (hasEventHandlers.supports(ViewEventType.TEXT_ENTER) && hasEventHandlers.supports(ViewEventType.TEXT_EXIT)) {
                TextEnterHandler enterHandler = new TextEnterHandler(){

                    public void handle(TextEnterEvent event) {
                        CanvasInPlaceTextEditorControlImpl.this.canvasHandler.getAbstractCanvas().getView().setCursor(AbstractCanvas.Cursors.TEXT);
                    }
                };
                hasEventHandlers.addHandler(ViewEventType.TEXT_ENTER, (ViewHandler)enterHandler);
                this.registerHandler(shape.getUUID(), (ViewHandler<?>)enterHandler);
                TextExitHandler exitHandler = new TextExitHandler(){

                    public void handle(TextExitEvent event) {
                        CanvasInPlaceTextEditorControlImpl.this.canvasHandler.getAbstractCanvas().getView().setCursor(AbstractCanvas.Cursors.AUTO);
                    }
                };
                hasEventHandlers.addHandler(ViewEventType.TEXT_EXIT, (ViewHandler)exitHandler);
                this.registerHandler(shape.getUUID(), (ViewHandler<?>)exitHandler);
            }
        }
    }

    public CanvasInPlaceTextEditorControl<AbstractCanvasHandler, Element> show(Element item, double x, double y) {
        double[] size;
        this.uuid = item.getUUID();
        this.enableShapeEdit();
        this.textEditorBox.show(item);
        try {
            size = GraphUtils.getNodeSize((View)((View)item.getContent()));
        }
        catch (ClassCastException e) {
            size = null;
        }
        double rx = null != size ? size[0] / 2.0 : 0.0;
        this.floatingView.setX(x - rx).setY(y).show();
        return this;
    }

    public CanvasInPlaceTextEditorControl<AbstractCanvasHandler, Element> hide() {
        if (this.isVisible()) {
            this.disableShapeEdit();
            this.uuid = null;
            this.textEditorBox.hide();
            this.floatingView.hide();
        }
        return this;
    }

    public void setCommandManagerProvider(RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> provider) {
        this.textEditorBox.setCommandManagerProvider(provider);
    }

    @Override
    protected void doDisable() {
        super.doDisable();
        this.disableShapeEdit();
        this.uuid = null;
        this.textEditorBox.hide();
        this.floatingView.destroy();
    }

    private boolean enableShapeEdit() {
        return this.setShapeEditMode(true);
    }

    private boolean disableShapeEdit() {
        return this.setShapeEditMode(false);
    }

    private boolean setShapeEditMode(boolean editMode) {
        Shape<?> shape = this.getShape(this.uuid);
        if (null != shape) {
            HasTitle hasTitle = (HasTitle)shape.getShapeView();
            double alpha = editMode ? 0.2 : 1.0;
            shape.getShapeView().setFillAlpha(alpha);
            hasTitle.setTitleAlpha(alpha);
            this.getCanvas().draw();
            return true;
        }
        return false;
    }

    private Shape<?> getShape(String uuid) {
        return null != uuid ? this.getCanvas().getShape(uuid) : null;
    }

    private boolean isVisible() {
        return null != this.uuid;
    }

    private Canvas getCanvas() {
        return this.canvasHandler.getCanvas();
    }

    void onKeyDownEvent(@Observes KeyDownEvent keyDownEvent) {
        PortablePreconditions.checkNotNull((String)"keyDownEvent", (Object)keyDownEvent);
        KeyboardEvent.Key key = keyDownEvent.getKey();
        if (null != key && KeyboardEvent.Key.ESC.equals((Object)key)) {
            this.hide();
        }
    }

    void onCanvasFocusedEvent(@Observes CanvasFocusedEvent canvasFocusedEvent) {
        PortablePreconditions.checkNotNull((String)"canvasFocusedEvent", (Object)canvasFocusedEvent);
        this.hide();
    }
}

