/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.builder.impl;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import org.kie.workbench.common.stunner.core.client.api.ClientDefinitionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.BuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.ElementBuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.request.ElementBuildRequest;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasLayoutUtils;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.RequiresCommandManager;
import org.kie.workbench.common.stunner.core.client.service.ClientFactoryService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommandImpl;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.MagnetConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.index.bounds.GraphBoundsIndexer;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.core.rule.RuleEvaluationContext;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.kie.workbench.common.stunner.core.rule.RuleSet;
import org.kie.workbench.common.stunner.core.rule.RuleViolations;
import org.kie.workbench.common.stunner.core.rule.context.CardinalityContext;
import org.kie.workbench.common.stunner.core.rule.context.impl.RuleContextBuilder;
import org.kie.workbench.common.stunner.core.rule.violations.DefaultRuleViolations;
import org.kie.workbench.common.stunner.core.util.UUID;
import org.kie.workbench.common.stunner.core.validation.Violation;

public abstract class AbstractElementBuilderControl
extends AbstractCanvasHandlerControl<AbstractCanvasHandler>
implements ElementBuilderControl<AbstractCanvasHandler> {
    private static Logger LOGGER = Logger.getLogger(AbstractElementBuilderControl.class.getName());
    private final ClientDefinitionManager clientDefinitionManager;
    private final ClientFactoryService clientFactoryServices;
    private final CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory;
    private final GraphUtils graphUtils;
    private final RuleManager ruleManager;
    private final GraphBoundsIndexer graphBoundsIndexer;
    private final CanvasLayoutUtils canvasLayoutUtils;
    private RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> commandManagerProvider;

    public AbstractElementBuilderControl(ClientDefinitionManager clientDefinitionManager, ClientFactoryService clientFactoryServices, GraphUtils graphUtils, RuleManager ruleManager, CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory, GraphBoundsIndexer graphBoundsIndexer, CanvasLayoutUtils canvasLayoutUtils) {
        this.clientDefinitionManager = clientDefinitionManager;
        this.clientFactoryServices = clientFactoryServices;
        this.graphUtils = graphUtils;
        this.ruleManager = ruleManager;
        this.canvasCommandFactory = canvasCommandFactory;
        this.graphBoundsIndexer = graphBoundsIndexer;
        this.canvasLayoutUtils = canvasLayoutUtils;
    }

    public void setCommandManagerProvider(RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> provider) {
        this.commandManagerProvider = provider;
    }

    public boolean allows(ElementBuildRequest<AbstractCanvasHandler> request) {
        double x = request.getX();
        double y = request.getY();
        Object definition = request.getDefinition();
        Node<View<?>, Edge> parent = this.getParent(x, y);
        Set labels = this.clientDefinitionManager.adapters().forDefinition().getLabels(definition);
        RuleSet ruleSet = this.canvasHandler.getRuleSet();
        if (null != parent) {
            Object parentDef = ((View)parent.getContent()).getDefinition();
            Set parentLabels = this.clientDefinitionManager.adapters().forDefinition().getLabels(parentDef);
            RuleViolations containmentViolations = this.ruleManager.evaluate(ruleSet, (RuleEvaluationContext)RuleContextBuilder.DomainContexts.containment((Set)parentLabels, (Set)labels));
            if (!this.isValid(containmentViolations)) {
                return false;
            }
        }
        Map graphLabelCount = GraphUtils.getLabelsCount((Graph)this.canvasHandler.getDiagram().getGraph(), (Set)labels);
        DefaultRuleViolations cardinalityViolations = new DefaultRuleViolations();
        labels.forEach(role -> {
            Integer roleCount = Optional.ofNullable(graphLabelCount.get(role)).orElse(0);
            RuleViolations violations = this.ruleManager.evaluate(ruleSet, (RuleEvaluationContext)RuleContextBuilder.DomainContexts.cardinality(Collections.singleton(role), (int)roleCount, Optional.of(CardinalityContext.Operation.ADD)));
            cardinalityViolations.addViolations(violations);
        });
        labels.stream().forEach(role -> {});
        return this.isValid((RuleViolations)cardinalityViolations);
    }

    public void build(ElementBuildRequest<AbstractCanvasHandler> request, final BuilderControl.BuildCallback buildCallback) {
        if (null == this.canvasHandler) {
            buildCallback.onSuccess(null);
            return;
        }
        double x = 0.0;
        double y = 0.0;
        if (request.getX() == -1.0 || request.getY() == -1.0) {
            double[] p = this.canvasLayoutUtils.getNext(this.canvasHandler, 75.0);
            x = p[0] + 50.0;
            y = p[1] > 0.0 ? p[1] : 200.0;
        } else {
            x = request.getX();
            y = request.getY();
        }
        Object definition = request.getDefinition();
        this.fireProcessingStarted();
        Node<View<?>, Edge> parent = this.getParent(x, y);
        Point2D childCoordinates = this.getChildCoordinates(parent, x, y);
        this.getCommands(definition, parent, childCoordinates.getX(), childCoordinates.getY(), new CommandsCallback(){

            @Override
            public void onComplete(String uuid, List<Command<AbstractCanvasHandler, CanvasViolation>> commands) {
                AbstractElementBuilderControl.this.getCommandManager().execute((Object)AbstractElementBuilderControl.this.canvasHandler, (Command)new CompositeCommandImpl.CompositeCommandBuilder().addCommands(commands).build());
                buildCallback.onSuccess(uuid);
                AbstractElementBuilderControl.this.fireProcessingCompleted();
            }

            @Override
            public void onError(ClientRuntimeError error) {
                buildCallback.onError(error);
                AbstractElementBuilderControl.this.fireProcessingCompleted();
            }
        });
    }

    @Override
    protected void doDisable() {
        this.graphBoundsIndexer.destroy();
        this.commandManagerProvider = null;
    }

    public void getCommands(Object definition, final Node<View<?>, Edge> parent, final double x, final double y, final CommandsCallback commandsCallback) {
        String defId = this.clientDefinitionManager.adapters().forDefinition().getId(definition);
        String uuid = UUID.uuid();
        this.clientFactoryServices.newElement(uuid, defId, new ServiceCallback<Element>(){

            public void onSuccess(Element element) {
                AbstractElementBuilderControl.this.getElementCommands(element, parent, x, y, new CommandsCallback(){

                    @Override
                    public void onComplete(String uuid, List<Command<AbstractCanvasHandler, CanvasViolation>> commands) {
                        commandsCallback.onComplete(uuid, commands);
                    }

                    @Override
                    public void onError(ClientRuntimeError error) {
                        commandsCallback.onError(error);
                    }
                });
            }

            public void onError(ClientRuntimeError error) {
                commandsCallback.onError(error);
            }
        });
    }

    public void getElementCommands(Element element, Node<View<?>, Edge> parent, double x, double y, CommandsCallback commandsCallback) {
        CanvasCommand command = null;
        if (element instanceof Node) {
            command = null != parent ? this.canvasCommandFactory.addChildNode(parent, (Node)element, this.getShapeSetId()) : this.canvasCommandFactory.addNode((Node)element, this.getShapeSetId());
        } else if (element instanceof Edge && null != parent) {
            command = this.canvasCommandFactory.addConnector(parent, (Edge)element, (Connection)MagnetConnection.Builder.forElement(parent), this.getShapeSetId());
        } else {
            throw new RuntimeException("Unrecognized element type for " + element);
        }
        CanvasCommand moveCanvasElementCommand = this.canvasCommandFactory.updatePosition((Node)element, Double.valueOf(x), Double.valueOf(y));
        LinkedList<Command<AbstractCanvasHandler, CanvasViolation>> commandList = new LinkedList<Command<AbstractCanvasHandler, CanvasViolation>>();
        commandList.add((Command<AbstractCanvasHandler, CanvasViolation>)command);
        commandList.add((Command<AbstractCanvasHandler, CanvasViolation>)moveCanvasElementCommand);
        commandsCallback.onComplete(element.getUUID(), commandList);
    }

    public Node<View<?>, Edge> getParent(double _x, double _y) {
        if (_x > -1.0 && _y > -1.0) {
            String rootUUID = this.canvasHandler.getDiagram().getMetadata().getCanvasRootUUID();
            this.graphBoundsIndexer.setRootUUID(rootUUID).build((Object)this.canvasHandler.getDiagram().getGraph());
            Node r = (Node)this.graphBoundsIndexer.getAt(_x, _y);
            return r;
        }
        return null;
    }

    public Point2D getChildCoordinates(Node<View<?>, Edge> parent, double _x, double _y) {
        if (null != parent) {
            Point2D parentCoords = GraphUtils.getPosition((View)((View)parent.getContent()));
            double x = _x - parentCoords.getX();
            double y = _y - parentCoords.getY();
            return new Point2D(x, y);
        }
        return new Point2D(_x, _y);
    }

    protected void fireProcessingStarted() {
    }

    protected void fireProcessingCompleted() {
    }

    protected boolean isValid(RuleViolations violations) {
        return !violations.violations(Violation.Type.ERROR).iterator().hasNext();
    }

    protected String getShapeSetId() {
        return this.canvasHandler.getDiagram().getMetadata().getShapeSetId();
    }

    CanvasCommandManager<AbstractCanvasHandler> getCommandManager() {
        return this.commandManagerProvider.getCommandManager();
    }

    public static interface CommandsCallback {
        public void onComplete(String var1, List<Command<AbstractCanvasHandler, CanvasViolation>> var2);

        public void onError(ClientRuntimeError var1);
    }
}

