/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.drag;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerRegistrationControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.drag.DragControl;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.RequiresCommandManager;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.HasDragBounds;
import org.kie.workbench.common.stunner.core.client.shape.view.HasEventHandlers;
import org.kie.workbench.common.stunner.core.client.shape.view.event.DragEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.DragHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseEnterEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseEnterHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseExitEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseExitHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;

@Dependent
public class DragControlImpl
extends AbstractCanvasHandlerRegistrationControl<AbstractCanvasHandler>
implements DragControl<AbstractCanvasHandler, Element> {
    private static Logger LOGGER = Logger.getLogger(DragControlImpl.class.getName());
    private static final int delta = 10;
    private final CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory;
    private RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> commandManagerProvider;
    protected final double[] dragShapeSize = new double[]{0.0, 0.0};

    protected DragControlImpl() {
        this(null);
    }

    @Inject
    public DragControlImpl(CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory) {
        this.canvasCommandFactory = canvasCommandFactory;
    }

    public void setCommandManagerProvider(RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> provider) {
        this.commandManagerProvider = provider;
    }

    public void register(final Element element) {
        AbstractCanvas canvas;
        Shape shape;
        if (this.checkNotRegistered(element) && (shape = (canvas = this.canvasHandler.getAbstractCanvas()).getShape(element.getUUID())).getShapeView() instanceof HasEventHandlers) {
            HasEventHandlers hasEventHandlers = (HasEventHandlers)shape.getShapeView();
            if (this.supportsDrag(hasEventHandlers)) {
                DragHandler handler = new DragHandler(){

                    public void start(DragEvent event) {
                        DragControlImpl.this.doDragStart(element);
                    }

                    public void handle(DragEvent event) {
                    }

                    public void end(DragEvent event) {
                        CommandResult result = DragControlImpl.this.doDragEnd(element);
                        if (CommandUtils.isError((CommandResult)result)) {
                            LOGGER.log(Level.SEVERE, "Update element's position command failed [result=" + result + "]");
                            event.getDragContext().reset();
                        }
                    }
                };
                hasEventHandlers.addHandler(ViewEventType.DRAG, (ViewHandler)handler);
                this.registerHandler(element.getUUID(), (ViewHandler<?>)handler);
            }
            if (shape.getShapeView() instanceof HasDragBounds) {
                this.ensureDragConstraints((HasDragBounds)shape.getShapeView());
            }
            if (this.supportsMouseEnter(hasEventHandlers) && this.supportsMouseExit(hasEventHandlers)) {
                MouseEnterHandler overHandler = new MouseEnterHandler(){

                    public void handle(MouseEnterEvent event) {
                        DragControlImpl.this.canvasHandler.getAbstractCanvas().getView().setCursor(AbstractCanvas.Cursors.MOVE);
                    }
                };
                hasEventHandlers.addHandler(ViewEventType.MOUSE_ENTER, (ViewHandler)overHandler);
                this.registerHandler(shape.getUUID(), (ViewHandler<?>)overHandler);
                MouseExitHandler outHandler = new MouseExitHandler(){

                    public void handle(MouseExitEvent event) {
                        DragControlImpl.this.canvasHandler.getAbstractCanvas().getView().setCursor(AbstractCanvas.Cursors.AUTO);
                    }
                };
                hasEventHandlers.addHandler(ViewEventType.MOUSE_EXIT, (ViewHandler)outHandler);
                this.registerHandler(shape.getUUID(), (ViewHandler<?>)outHandler);
            }
        }
    }

    public CommandResult<CanvasViolation> move(Element element, double tx, double ty) {
        CanvasCommand c = this.canvasCommandFactory.updatePosition((Node)element, Double.valueOf(tx), Double.valueOf(ty));
        CommandResult result = this.getCommandManager().allow((Object)this.canvasHandler, (Command)c);
        if (!CommandUtils.isError((CommandResult)result)) {
            result = this.getCommandManager().execute((Object)this.canvasHandler, (Command)c);
        }
        return result;
    }

    public CommandResult<CanvasViolation> moveUp(Element element) {
        return this.translate(element, 0.0, -10.0);
    }

    public CommandResult<CanvasViolation> moveDown(Element element) {
        return this.translate(element, 0.0, 10.0);
    }

    public CommandResult<CanvasViolation> moveLeft(Element element) {
        return this.translate(element, -10.0, 0.0);
    }

    public CommandResult<CanvasViolation> moveRight(Element element) {
        return this.translate(element, 10.0, 0.0);
    }

    public CommandResult<CanvasViolation> translate(Element element, double dx, double dy) {
        Point2D p;
        try {
            p = GraphUtils.getPosition((View)((View)element.getContent()));
        }
        catch (ClassCastException e) {
            LOGGER.log(Level.WARNING, "Update element's position command only cannot be applied to View elements.");
            return CanvasCommandResultBuilder.FAILED;
        }
        double tx = p.getX() + dx;
        double ty = p.getY() + dy;
        return this.move(element, tx, ty);
    }

    @Override
    protected void doDisable() {
        super.doDisable();
        this.commandManagerProvider = null;
    }

    protected void ensureDragConstraints(HasDragBounds<?> shapeView) {
        Graph graph = this.canvasHandler.getGraphIndex().getGraph();
        Bounds bounds = ((DefinitionSet)graph.getContent()).getBounds();
        shapeView.setDragBounds(bounds.getUpperLeft().getX().doubleValue(), bounds.getUpperLeft().getY().doubleValue(), bounds.getLowerRight().getX().doubleValue(), bounds.getLowerRight().getY().doubleValue());
    }

    private void doDragStart(Element element) {
        double[] size = GraphUtils.getNodeSize((View)((View)element.getContent()));
        this.dragShapeSize[0] = size[0];
        this.dragShapeSize[1] = size[1];
    }

    private CommandResult<CanvasViolation> doDragEnd(Element element) {
        AbstractCanvas canvas = this.canvasHandler.getAbstractCanvas();
        Shape shape = canvas.getShape(element.getUUID());
        double x = shape.getShapeView().getShapeX();
        double y = shape.getShapeView().getShapeY();
        return this.move(element, x, y);
    }

    private boolean supportsDrag(HasEventHandlers shapeView) {
        return shapeView.supports(ViewEventType.DRAG);
    }

    private boolean supportsMouseEnter(HasEventHandlers shapeView) {
        return shapeView.supports(ViewEventType.MOUSE_ENTER);
    }

    private boolean supportsMouseExit(HasEventHandlers shapeView) {
        return shapeView.supports(ViewEventType.MOUSE_EXIT);
    }

    private CanvasCommandManager<AbstractCanvasHandler> getCommandManager() {
        return this.commandManagerProvider.getCommandManager();
    }
}

