/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.select;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Layer;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerRegistrationControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.select.SelectionControl;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasShapeRemovedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasClearSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasElementSelectedEvent;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.client.shape.view.HasEventHandlers;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.uberfire.commons.validation.PortablePreconditions;

@Dependent
public final class SelectionControlImpl<H extends AbstractCanvasHandler>
extends AbstractCanvasHandlerRegistrationControl<H>
implements SelectionControl<H, Element> {
    private final Event<CanvasElementSelectedEvent> elementSelectedEvent;
    private final Event<CanvasClearSelectionEvent> clearSelectionEvent;
    private ViewHandler<?> layerClickHandler;
    private String selectedElementUUID;

    @Inject
    public SelectionControlImpl(Event<CanvasElementSelectedEvent> elementSelectedEvent, Event<CanvasClearSelectionEvent> clearSelectionEvent) {
        this.elementSelectedEvent = elementSelectedEvent;
        this.clearSelectionEvent = clearSelectionEvent;
    }

    @Override
    public void enable(H canvasHandler) {
        super.enable(canvasHandler);
        Layer layer = canvasHandler.getCanvas().getLayer();
        MouseClickHandler clickHandler = new MouseClickHandler((AbstractCanvasHandler)canvasHandler){
            final /* synthetic */ AbstractCanvasHandler val$canvasHandler;
            {
                this.val$canvasHandler = abstractCanvasHandler;
            }

            public void handle(MouseClickEvent event) {
                if (event.isButtonLeft()) {
                    SelectionControlImpl.this.clearSelection(false);
                    String canvasRootUUID = SelectionControlImpl.this.getRootUUID();
                    SelectionControlImpl.this.fireCanvasClear();
                    if (null != canvasRootUUID) {
                        SelectionControlImpl.this.elementSelectedEvent.fire((Object)new CanvasElementSelectedEvent((CanvasHandler)this.val$canvasHandler, canvasRootUUID));
                    }
                }
            }
        };
        layer.addHandler(ViewEventType.MOUSE_CLICK, (ViewHandler)clickHandler);
        this.layerClickHandler = clickHandler;
    }

    public void register(final Element element) {
        HasEventHandlers hasEventHandlers;
        ShapeView shapeView;
        Shape shape;
        if (this.isEnabled() && this.checkNotRegistered(element) && null != (shape = this.getCanvas().getShape(element.getUUID())) && (shapeView = shape.getShapeView()) instanceof HasEventHandlers && (hasEventHandlers = (HasEventHandlers)shapeView).supports(ViewEventType.MOUSE_CLICK)) {
            MouseClickHandler clickHandler = new MouseClickHandler(){

                public void handle(MouseClickEvent event) {
                    if (event.isButtonLeft()) {
                        SelectionControlImpl.this.select(element);
                    }
                }
            };
            hasEventHandlers.addHandler(ViewEventType.MOUSE_CLICK, (ViewHandler)clickHandler);
            this.registerHandler(shape.getUUID(), (ViewHandler<?>)clickHandler);
        }
    }

    public SelectionControl<H, Element> select(Element element) {
        return this.select(element.getUUID());
    }

    private SelectionControl<H, Element> select(String uuid) {
        if (null != this.selectedElementUUID && !this.isSelected(uuid)) {
            this.deselect(uuid);
            this.fireCanvasClear();
        }
        if (null == this.selectedElementUUID) {
            this.selectedElementUUID = uuid;
            this.updateViewShapesState();
            this.elementSelectedEvent.fire((Object)new CanvasElementSelectedEvent((CanvasHandler)this.canvasHandler, uuid));
        }
        return this;
    }

    public SelectionControl<H, Element> deselect(Element element) {
        return this.deselect(element.getUUID());
    }

    private SelectionControl<H, Element> deselect(String uuid) {
        if (this.isSelected(uuid)) {
            this.selectedElementUUID = null;
            this.updateViewShapesState();
        }
        return this;
    }

    public boolean isSelected(Element element) {
        return element.getUUID().equals(this.selectedElementUUID);
    }

    private boolean isSelected(String uuid) {
        return null != this.selectedElementUUID && this.selectedElementUUID.equals(uuid);
    }

    public Collection<String> getSelectedItems() {
        return Collections.singleton(this.selectedElementUUID);
    }

    public SelectionControl<H, Element> clearSelection() {
        return this.clearSelection(true);
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && null != this.canvasHandler.getCanvas();
    }

    @Override
    public void deregisterAll() {
        super.deregisterAll();
        this.clearSelection(false);
    }

    @Override
    public void deregister(String uuid) {
        super.deregister(uuid);
        this.deselect(uuid);
    }

    @Override
    protected void doDisable() {
        super.doDisable();
        if (this.isEnabled() && null != this.layerClickHandler && null != this.getCanvas().getLayer()) {
            this.getCanvas().getLayer().removeHandler(this.layerClickHandler);
            this.layerClickHandler = null;
        }
    }

    void onShapeRemovedEvent(@Observes CanvasShapeRemovedEvent shapeRemovedEvent) {
        PortablePreconditions.checkNotNull((String)"shapeRemovedEvent", (Object)shapeRemovedEvent);
        if (this.isEnabled() && this.getCanvas().equals(shapeRemovedEvent.getCanvas())) {
            Shape shape = shapeRemovedEvent.getShape();
            this.deselect(shape.getUUID());
        }
    }

    void onCanvasElementSelectedEvent(@Observes CanvasElementSelectedEvent event) {
        boolean isCanvasRoot;
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        String uuid = event.getElementUUID();
        boolean isSameCtxt = null != this.canvasHandler && this.canvasHandler.equals(event.getCanvasHandler());
        boolean bl = isCanvasRoot = null != this.canvasHandler && uuid.equals(this.getRootUUID());
        if (isSameCtxt && !isCanvasRoot) {
            this.select(uuid);
        } else if (isSameCtxt) {
            this.clearSelection(false);
        }
    }

    void CanvasClearSelectionEvent(@Observes CanvasClearSelectionEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        if (null != this.canvasHandler && this.canvasHandler.equals(event.getCanvasHandler())) {
            this.clearSelection(false);
        }
    }

    private SelectionControl<H, Element> clearSelection(boolean fireEvent) {
        this.deselect(this.selectedElementUUID);
        if (null != this.getCanvas()) {
            this.getCanvas().draw();
        }
        if (fireEvent) {
            this.fireCanvasClear();
        }
        return this;
    }

    private void updateViewShapesState() {
        if (this.isEnabled()) {
            List shapes = this.getCanvas().getShapes();
            for (Shape shape : shapes) {
                boolean isSelected;
                boolean bl = isSelected = null != this.selectedElementUUID && this.selectedElementUUID.equals(shape.getUUID());
                if (isSelected) {
                    shape.applyState(ShapeState.SELECTED);
                    continue;
                }
                shape.applyState(ShapeState.NONE);
            }
            this.getCanvas().draw();
        }
    }

    private void fireCanvasClear() {
        this.clearSelectionEvent.fire((Object)new CanvasClearSelectionEvent((CanvasHandler)this.canvasHandler));
    }

    private Canvas getCanvas() {
        return this.canvasHandler.getCanvas();
    }

    private String getRootUUID() {
        return this.canvasHandler.getDiagram().getMetadata().getCanvasRootUUID();
    }
}

