/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox;

import java.util.Iterator;
import java.util.List;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.ToolboxControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.ToolboxControlImpl;
import org.kie.workbench.common.stunner.core.client.canvas.event.AbstractCanvasHandlerEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.AbstractCanvasShapeEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasShapeRemovedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasClearSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasElementSelectedEvent;
import org.kie.workbench.common.stunner.core.client.components.toolbox.Toolbox;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ActionsToolboxFactory;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.uberfire.commons.validation.PortablePreconditions;

public abstract class AbstractToolboxControl
implements ToolboxControl<AbstractCanvasHandler, Element> {
    private final ToolboxControlImpl<ActionsToolboxFactory> toolboxControl;

    protected abstract List<ActionsToolboxFactory> getFactories();

    @Inject
    public AbstractToolboxControl() {
        this.toolboxControl = new ToolboxControlImpl(this::getFactories);
    }

    AbstractToolboxControl(ToolboxControlImpl<ActionsToolboxFactory> toolboxControl) {
        this.toolboxControl = toolboxControl;
    }

    public void enable(AbstractCanvasHandler context) {
        this.toolboxControl.enable(context);
    }

    public void disable() {
        this.toolboxControl.disable();
    }

    public void register(Element element) {
        this.toolboxControl.register(element);
    }

    public void deregister(Element element) {
        this.toolboxControl.deregister(element);
    }

    public Iterator<Toolbox<?>> getToolboxes(Element element) {
        return this.toolboxControl.getToolboxes(element);
    }

    void onCanvasElementSelectedEvent(@Observes CanvasElementSelectedEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        this.handleCanvasElementSelectedEvent(event);
    }

    void onCanvasClearSelectionEvent(@Observes CanvasClearSelectionEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        this.handleCanvasClearSelectionEvent(event);
    }

    void onCanvasShapeRemovedEvent(@Observes CanvasShapeRemovedEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        this.handleCanvasShapeRemovedEvent(event);
    }

    protected void handleCanvasElementSelectedEvent(CanvasElementSelectedEvent event) {
        if (this.checkEventContext((AbstractCanvasHandlerEvent)event)) {
            this.toolboxControl.show(event.getElementUUID());
        }
    }

    protected void handleCanvasClearSelectionEvent(CanvasClearSelectionEvent event) {
        if (this.checkEventContext((AbstractCanvasHandlerEvent)event)) {
            this.toolboxControl.destroy();
        }
    }

    protected void handleCanvasShapeRemovedEvent(CanvasShapeRemovedEvent event) {
        if (this.checkEventContext((AbstractCanvasShapeEvent)event)) {
            this.toolboxControl.destroy();
        }
    }

    private boolean checkEventContext(AbstractCanvasHandlerEvent canvasHandlerEvent) {
        CanvasHandler _canvasHandler = canvasHandlerEvent.getCanvasHandler();
        return this.toolboxControl.getCanvasHandler() != null && this.toolboxControl.getCanvasHandler().equals(_canvasHandler);
    }

    private boolean checkEventContext(AbstractCanvasShapeEvent canvasShapeEvent) {
        return this.toolboxControl.getCanvasHandler() != null && this.toolboxControl.getCanvasHandler().getCanvas().equals(canvasShapeEvent.getCanvas()) && this.toolboxControl.isActive(canvasShapeEvent.getShape().getUUID());
    }
}

