/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.util;

import java.util.LinkedList;
import java.util.List;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.rule.RuleViolations;

public class CanvasHighlight {
    private final AbstractCanvasHandler canvasHandler;
    private final List<String> uuids = new LinkedList<String>();

    public CanvasHighlight(AbstractCanvasHandler canvasHandler) {
        this.canvasHandler = canvasHandler;
    }

    public CanvasHighlight highLight(Element<?> node) {
        this.applyState(node, ShapeState.HIGHLIGHT);
        return this;
    }

    public CanvasHighlight invalid(Element<?> node) {
        this.applyState(node, ShapeState.INVALID);
        return this;
    }

    public CanvasHighlight invalid(RuleViolations violations) {
        this.invalid(violations.violations());
        return this;
    }

    public CanvasHighlight invalid(Iterable<? extends RuleViolation> violations) {
        violations.forEach(v -> {
            String uuid = v.getUUID();
            this.applyStateToShape(uuid, ShapeState.INVALID);
        });
        this.getCanvas().draw();
        return this;
    }

    public CanvasHighlight none(Element<?> node) {
        this.applyState(node, ShapeState.NONE);
        return this;
    }

    public CanvasHighlight unhighLight() {
        if (!this.uuids.isEmpty()) {
            this.uuids.forEach(uuid -> {
                Shape shape = this.getShape((String)uuid);
                if (null != shape) {
                    shape.applyState(ShapeState.NONE);
                }
            });
            this.getCanvas().draw();
            this.uuids.clear();
        }
        return this;
    }

    public void destroy() {
        this.uuids.clear();
    }

    private void applyState(Element<?> node, ShapeState state) {
        this.applyStateToShape(node.getUUID(), state);
        this.getCanvas().draw();
    }

    private void applyStateToShape(String uuid, ShapeState state) {
        Shape shape = this.getShape(uuid);
        if (null != shape) {
            this.uuids.add(uuid);
            shape.applyState(state);
        }
    }

    private Shape getShape(String uuid) {
        return this.getCanvas().getShape(uuid);
    }

    private AbstractCanvas getCanvas() {
        return this.canvasHandler.getAbstractCanvas();
    }
}

