/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.util;

import com.google.gwt.logging.client.LogConfiguration;
import com.google.gwt.user.client.Timer;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Dock;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.ContentTraverseCallback;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.ViewTraverseProcessorImpl;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeWalkTraverseProcessor;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeWalkTraverseProcessorImpl;
import org.uberfire.mvp.Command;

public class CanvasHighlightVisitor {
    private static Logger LOGGER = Logger.getLogger(CanvasHighlightVisitor.class.getName());
    private static final int TIMER_DELAY = 500;
    private CanvasHandler canvasHandler;
    private final List<Shape> shapes = new LinkedList<Shape>();

    public void run(CanvasHandler canvasHandler, Command callback) {
        this.canvasHandler = canvasHandler;
        this.prepareVisit(() -> this.animate(0, () -> {
            this.log(Level.FINE, "CanvasHighlightVisitor - FINISHED");
            if (null != callback) {
                callback.execute();
                this.canvasHandler = null;
                this.shapes.clear();
            }
        }));
    }

    private void animate(final int index, final Command callback) {
        if (index < this.shapes.size()) {
            Shape shape = this.shapes.get(index);
            shape.applyState(ShapeState.HIGHLIGHT);
            this.canvasHandler.getCanvas().draw();
            Timer t = new Timer(){

                public void run() {
                    CanvasHighlightVisitor.this.animate(index + 1, callback);
                }
            };
            t.schedule(500);
        } else {
            callback.execute();
        }
    }

    private void prepareVisit(final Command command) {
        Graph graph = this.canvasHandler.getDiagram().getGraph();
        TreeWalkTraverseProcessorImpl treeWalkTraverseProcessor = new TreeWalkTraverseProcessorImpl().useStartNodePredicate(this::isStartNode);
        new ViewTraverseProcessorImpl((TreeWalkTraverseProcessor)treeWalkTraverseProcessor).traverse(graph, new ContentTraverseCallback<View<?>, Node<View, Edge>, Edge<View<?>, Node>>(){

            public void startGraphTraversal(Graph<DefinitionSet, Node<View, Edge>> graph) {
            }

            public void startEdgeTraversal(Edge<View<?>, Node> edge) {
                this.addShape(edge.getUUID());
            }

            public void endEdgeTraversal(Edge<View<?>, Node> edge) {
            }

            public void startNodeTraversal(Node<View, Edge> node) {
                this.addShape(node.getUUID());
            }

            public void endNodeTraversal(Node<View, Edge> node) {
            }

            public void endGraphTraversal() {
                command.execute();
            }

            private void addShape(String uuid) {
                Shape shape = CanvasHighlightVisitor.this.canvasHandler.getCanvas().getShape(uuid);
                if (null != shape) {
                    CanvasHighlightVisitor.this.shapes.add(shape);
                }
            }
        });
    }

    private boolean isStartNode(Node<?, Edge> node) {
        boolean hasConnectors = node.getInEdges().stream().filter(e -> e.getContent() instanceof View).findAny().isPresent();
        boolean hasDocks = node.getInEdges().stream().filter(e -> e.getContent() instanceof Dock).findAny().isPresent();
        return !hasConnectors && !hasDocks;
    }

    private void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }
}

