/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.util;

import java.util.LinkedList;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.uberfire.commons.validation.PortablePreconditions;

@Dependent
public class CanvasLayoutUtils {
    private static final int PADDING_X = 40;
    private static final int PADDING_Y = 40;

    public static boolean isCanvasRoot(Diagram diagram, Element parent) {
        return null != parent && CanvasLayoutUtils.isCanvasRoot(diagram, parent.getUUID());
    }

    public static boolean isCanvasRoot(Diagram diagram, String pUUID) {
        String canvasRoot = diagram.getMetadata().getCanvasRootUUID();
        return null != canvasRoot && null != pUUID && canvasRoot.equals(pUUID);
    }

    public double[] getNext(CanvasHandler canvasHandler, double height) {
        Point2D point2D = new Point2D(0.0, 0.0);
        return this.getNext(canvasHandler, height, point2D);
    }

    public double[] getNext(CanvasHandler canvasHandler, double height, Point2D offset) {
        PortablePreconditions.checkNotNull((String)"canvasHandler", (Object)canvasHandler);
        Bounds bounds = this.getGraphBounds(canvasHandler);
        Bounds.Bound ul = bounds.getUpperLeft();
        String ruuid = canvasHandler.getDiagram().getMetadata().getCanvasRootUUID();
        Point2D min = new Point2D(ul.getX().doubleValue(), ul.getY().doubleValue());
        if (null != ruuid) {
            Node root = canvasHandler.getDiagram().getGraph().getNode(ruuid);
            return this.getNext(canvasHandler, root, height, offset, min);
        }
        Iterable nodes = canvasHandler.getDiagram().getGraph().nodes();
        if (null != nodes) {
            Bounds.Bound lr = bounds.getLowerRight();
            LinkedList nodeList = new LinkedList();
            nodes.forEach(nodeList::add);
            return this.getNext(canvasHandler, nodeList, height, offset, min, lr.getX() - 40.0);
        }
        return new double[]{ul.getX(), ul.getY()};
    }

    public double[] getNext(CanvasHandler canvasHandler, double h, Point2D offset, Point2D min) {
        PortablePreconditions.checkNotNull((String)"canvasHandler", (Object)canvasHandler);
        String ruuid = canvasHandler.getDiagram().getMetadata().getCanvasRootUUID();
        if (null != ruuid) {
            Node root = canvasHandler.getDiagram().getGraph().getNode(ruuid);
            return this.getNext(canvasHandler, root, h, offset, min);
        }
        Bounds bounds = this.getGraphBounds(canvasHandler);
        Bounds.Bound lr = bounds.getLowerRight();
        Iterable nodes = canvasHandler.getDiagram().getGraph().nodes();
        if (null != nodes) {
            LinkedList nodeList = new LinkedList();
            nodes.forEach(nodeList::add);
            return this.getNext(canvasHandler, nodeList, h, offset, min, lr.getX() - 40.0);
        }
        return new double[]{min.getX(), min.getY()};
    }

    public double[] getNext(CanvasHandler canvasHandler, Node<View<?>, Edge> root, Node<View<?>, Edge> newNode) {
        double[] rootBounds = this.getBoundCoordinates((View)root.getContent());
        double[] rootSize = GraphUtils.getNodeSize((View)((View)root.getContent()));
        double[] newNodeSize = GraphUtils.getNodeSize((View)((View)newNode.getContent()));
        Point2D newNodePosition = GraphUtils.getPosition((View)((View)newNode.getContent()));
        Point2D[] offset = new Point2D[]{new Point2D(0.0, 0.0)};
        Point2D[] parentOffset = new Point2D[]{new Point2D(0.0, 0.0)};
        Node parent = (Node)GraphUtils.getParent(root);
        if (parent != null && GraphUtils.hasChildren((Node)parent)) {
            Point2D pos = GraphUtils.getPosition((View)((View)parent.getContent()));
            parentOffset[0] = new Point2D(pos.getX() + newNodePosition.getX() + 40.0, pos.getY() + newNodePosition.getY());
            offset[0].setX(parentOffset[0].getX());
        }
        double[] maxNodeY = new double[]{0.0};
        if (root.getOutEdges().size() > 0) {
            root.getOutEdges().forEach(n -> {
                Node node = n.getTargetNode();
                Point2D nodePos = GraphUtils.getPosition((View)((View)node.getContent()));
                Point2D rootPos = GraphUtils.getPosition((View)((View)root.getContent()));
                if (nodePos.getY() > maxNodeY[0]) {
                    maxNodeY[0] = nodePos.getY();
                    double[] nodeSize = GraphUtils.getNodeSize((View)((View)node.getContent()));
                    offset[0].setY(maxNodeY[0] + nodeSize[1] - rootPos.getY());
                }
            });
            offset[0].setY(offset[0].getY() + parentOffset[0].getY() + 40.0);
        } else {
            offset[0].setY(parentOffset[0].getY() - (newNodeSize[1] - rootSize[1]) / 2.0);
        }
        offset[0].setX(offset[0].getX() + 40.0);
        Point2D offsetCoordinates = new Point2D(offset[0].getX(), offset[0].getY());
        Point2D rootBoundsCoordinates = new Point2D(rootBounds[0], rootBounds[1]);
        return this.getNext(canvasHandler, root, rootSize[1], offsetCoordinates, rootBoundsCoordinates);
    }

    public double[] getNext(CanvasHandler canvasHandler, Node<View<?>, Edge> root, double h, Point2D offset, Point2D min) {
        PortablePreconditions.checkNotNull((String)"canvasHandler", (Object)canvasHandler);
        PortablePreconditions.checkNotNull((String)"root", root);
        List outEdges = root.getOutEdges();
        double[] totHeight = new double[]{0.0};
        if (null != outEdges) {
            LinkedList nodes = new LinkedList();
            outEdges.stream().forEach(edge -> {
                if (edge instanceof Child && edge.getTargetNode().getContent() instanceof View) {
                    nodes.add(edge.getTargetNode());
                }
            });
            if (!nodes.isEmpty()) {
                double[] rootBounds = this.getBoundCoordinates((View)root.getContent());
                double[] n = this.getNext(canvasHandler, nodes, h, offset, min, rootBounds[0] - 40.0);
                return new double[]{n[0] + 40.0, n[1]};
            }
        }
        double[] nextPosition = this.getNextPositionWithOffset(min, offset);
        return nextPosition;
    }

    private double[] getNext(CanvasHandler canvasHandler, List<Node<View<?>, Edge>> nodes, double width, Point2D offset, Point2D min, double maxX) {
        PortablePreconditions.checkNotNull((String)"canvasHandler", (Object)canvasHandler);
        PortablePreconditions.checkNotNull((String)"nodes", nodes);
        double[] result = new double[]{min.getX(), min.getY()};
        nodes.stream().forEach(node -> {
            double[] coordinates = this.getAbsolute((Node<View<?>, Edge>)node);
            result[0] = coordinates[0] >= result[0] ? coordinates[0] : result[0];
            result[1] = coordinates[1] >= result[1] ? coordinates[1] : result[1];
            result[0] = result[0] + offset.getX();
            result[1] = result[1] + offset.getY() + 40.0;
            Point2D coordinatesPoint = new Point2D(coordinates[0], coordinates[1]);
            double[] r = this.getNextPositionWithOffset(coordinatesPoint, offset);
            if (coordinates[0] + width >= maxX) {
                result[0] = r[0];
                result[1] = r[1];
            }
        });
        return result;
    }

    private double[] getNextPositionWithOffset(Point2D nextPosition, Point2D offset) {
        double[] result = new double[]{nextPosition.getX(), nextPosition.getY()};
        double[] res = new double[]{result[0] + offset.getX(), result[1] + offset.getY()};
        return res;
    }

    private double[] getAbsolute(Node<View<?>, Edge> root) {
        double[] pos = this.getBoundCoordinates((View)root.getContent());
        return this.getAbsolute(root, pos[0], pos[1]);
    }

    private double[] getAbsolute(Node<View<?>, Edge> root, double x, double y) {
        Element parent = GraphUtils.getParent(root);
        if (null != parent && parent instanceof Node && parent.getContent() instanceof View) {
            double[] pos = this.getBoundCoordinates((View)parent.getContent());
            return this.getAbsolute((Node)parent, x + pos[0], y + pos[1]);
        }
        return new double[]{x, y};
    }

    private double[] getBoundCoordinates(View view) {
        Bounds bounds = view.getBounds();
        Bounds.Bound ulBound = bounds.getUpperLeft();
        Bounds.Bound lrBound = bounds.getLowerRight();
        double lrX = lrBound.getX();
        double lrY = ulBound.getY();
        return new double[]{lrX, lrY};
    }

    private Bounds getGraphBounds(CanvasHandler canvasHandler) {
        Graph graph = canvasHandler.getDiagram().getGraph();
        return ((DefinitionSet)graph.getContent()).getBounds();
    }
}

