/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.command;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.kie.workbench.common.stunner.core.client.api.AbstractClientSessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.session.ClientFullSession;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandListener;
import org.kie.workbench.common.stunner.core.command.CommandManager;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.DelegateCommandManager;
import org.kie.workbench.common.stunner.core.command.HasCommandListener;
import org.kie.workbench.common.stunner.core.command.exception.CommandException;
import org.kie.workbench.common.stunner.core.registry.command.CommandRegistry;

public abstract class AbstractSessionCommandManager
extends DelegateCommandManager<AbstractCanvasHandler, CanvasViolation>
implements SessionCommandManager<AbstractCanvasHandler> {
    private static Logger LOGGER = Logger.getLogger(AbstractSessionCommandManager.class.getName());
    private CommandListener<AbstractCanvasHandler, CanvasViolation> listener;

    protected abstract AbstractClientSessionManager getClientSessionManager();

    protected abstract CommandListener<AbstractCanvasHandler, CanvasViolation> getRegistryListener();

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context, Command<AbstractCanvasHandler, CanvasViolation> command) {
        try {
            return super.execute((Object)context, command);
        }
        catch (CommandException ce) {
            this.getClientSessionManager().handleCommandError(ce);
        }
        catch (RuntimeException e) {
            this.getClientSessionManager().handleClientError(new ClientRuntimeError((Throwable)e));
        }
        return CanvasCommandResultBuilder.FAILED;
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        Command lastEntry = this.getRegistry().peek();
        if (null != lastEntry) {
            try {
                return this.getDelegate().undo((Object)context, lastEntry);
            }
            catch (CommandException ce) {
                this.getClientSessionManager().handleCommandError(ce);
            }
            catch (RuntimeException e) {
                this.getClientSessionManager().handleClientError(new ClientRuntimeError((Throwable)e));
            }
            return CanvasCommandResultBuilder.FAILED;
        }
        return null;
    }

    public ClientSession<AbstractCanvas, AbstractCanvasHandler> getCurrentSession() {
        return this.getClientSessionManager().getCurrentSession();
    }

    protected CommandManager<AbstractCanvasHandler, CanvasViolation> getDelegate() {
        ClientFullSession<AbstractCanvas, AbstractCanvasHandler> session = this.getFullSession();
        if (null != session) {
            CanvasCommandManager commandManager = session.getCommandManager();
            try {
                HasCommandListener hasCommandListener = (HasCommandListener)commandManager;
                hasCommandListener.setCommandListener(this.getRegistryListener());
            }
            catch (ClassCastException e) {
                LOGGER.log(Level.WARNING, "Current command manager for canvas does not supportcommand listeners. Session's registry cannot be updated.");
            }
            return commandManager;
        }
        return null;
    }

    public CommandRegistry<Command<AbstractCanvasHandler, CanvasViolation>> getRegistry() {
        ClientFullSession<AbstractCanvas, AbstractCanvasHandler> session = this.getFullSession();
        if (null != session) {
            return session.getCommandRegistry();
        }
        return null;
    }

    private ClientFullSession<AbstractCanvas, AbstractCanvasHandler> getFullSession() {
        ClientSession<AbstractCanvas, AbstractCanvasHandler> session = this.getCurrentSession();
        try {
            return (ClientFullSession)session;
        }
        catch (ClassCastException e) {
            LOGGER.log(Level.WARNING, "Session is not type of client full session.");
            return null;
        }
    }

    public String toString() {
        return "[" + ((Object)((Object)this)).getClass().getName() + "] - Current session = [" + (null != this.getCurrentSession() ? this.getCurrentSession().toString() : "null") + "]";
    }

    protected void postAllow(AbstractCanvasHandler context, Command<AbstractCanvasHandler, CanvasViolation> command, CommandResult<CanvasViolation> result) {
        super.postAllow((Object)context, command, result);
        if (null != this.listener) {
            this.listener.onAllow((Object)context, command, result);
        }
    }

    protected void postExecute(AbstractCanvasHandler context, Command<AbstractCanvasHandler, CanvasViolation> command, CommandResult<CanvasViolation> result) {
        super.postExecute((Object)context, command, result);
        if (null != this.listener) {
            this.listener.onExecute((Object)context, command, result);
        }
    }

    protected void postUndo(AbstractCanvasHandler context, Command<AbstractCanvasHandler, CanvasViolation> command, CommandResult<CanvasViolation> result) {
        super.postUndo((Object)context, command, result);
        if (null != this.listener) {
            this.listener.onUndo((Object)context, command, result);
        }
    }

    public void setCommandListener(CommandListener<AbstractCanvasHandler, CanvasViolation> listener) {
        if (null != this.listener) {
            LOGGER.log(Level.WARNING, "Overriding listener for the session's command manager.");
        }
        this.listener = listener;
    }
}

