/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.command;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.api.AbstractClientSessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.mouse.CanvasMouseDownEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.mouse.CanvasMouseUpEvent;
import org.kie.workbench.common.stunner.core.client.command.AbstractSessionCommandManager;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.Request;
import org.kie.workbench.common.stunner.core.client.session.event.SessionDestroyedEvent;
import org.kie.workbench.common.stunner.core.client.session.event.SessionOpenedEvent;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandListener;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.impl.CommandRegistryListener;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommandImpl;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.registry.command.CommandRegistry;
import org.uberfire.commons.validation.PortablePreconditions;

@ApplicationScoped
@Request
public class RequestCommandManager
extends AbstractSessionCommandManager {
    private static Logger LOGGER = Logger.getLogger(RequestCommandManager.class.getName());
    private final AbstractClientSessionManager clientSessionManager;
    private CompositeCommandImpl.CompositeCommandBuilder<AbstractCanvasHandler, CanvasViolation> currentCommandBuilder;
    private CommandListener<AbstractCanvasHandler, CanvasViolation> registryListener = new CommandRegistryListener<AbstractCanvasHandler, CanvasViolation>(){

        public void onAllow(AbstractCanvasHandler context, Command<AbstractCanvasHandler, CanvasViolation> command, CommandResult<CanvasViolation> result) {
            RequestCommandManager.this.postAllow(context, command, result);
        }

        public void onExecute(AbstractCanvasHandler context, Command<AbstractCanvasHandler, CanvasViolation> command, CommandResult<CanvasViolation> result) {
            if (!CommandUtils.isError(result)) {
                LOGGER.log(Level.FINEST, "Adding command [" + command + "] into current request command builder.");
                RequestCommandManager.this.currentCommandBuilder.addCommand(command);
            }
            RequestCommandManager.this.postExecute(context, command, result);
        }

        public void onUndo(AbstractCanvasHandler context, Command<AbstractCanvasHandler, CanvasViolation> command, CommandResult<CanvasViolation> result) {
            super.onUndo((Object)context, command, result);
            RequestCommandManager.this.postUndo(context, command, result);
        }

        protected CommandRegistry<Command<AbstractCanvasHandler, CanvasViolation>> getRegistry() {
            return RequestCommandManager.this.getRegistry();
        }
    };

    protected RequestCommandManager() {
        this(null);
    }

    @Inject
    public RequestCommandManager(AbstractClientSessionManager clientSessionManager) {
        this.clientSessionManager = clientSessionManager;
    }

    @Override
    protected AbstractClientSessionManager getClientSessionManager() {
        return this.clientSessionManager;
    }

    @Override
    protected CommandListener<AbstractCanvasHandler, CanvasViolation> getRegistryListener() {
        return this.registryListener;
    }

    void onCanvasMouseDownEvent(@Observes CanvasMouseDownEvent mouseDownEvent) {
        PortablePreconditions.checkNotNull((String)"mouseDownEvent", (Object)mouseDownEvent);
        this.start();
    }

    void onCanvasMouseUpEvent(@Observes CanvasMouseUpEvent mouseUpEvent) {
        PortablePreconditions.checkNotNull((String)"mouseUpEvent", (Object)mouseUpEvent);
        this.complete();
    }

    void onCanvasSessionOpened(@Observes SessionOpenedEvent sessionOpenedEvent) {
        PortablePreconditions.checkNotNull((String)"sessionOpenedEvent", (Object)sessionOpenedEvent);
        if (this.isRequestStarted()) {
            LOGGER.log(Level.WARNING, "New session opened but the request has not been completed. Unexpected behaviors can occur.");
            this.clear();
        }
    }

    void onCanvasSessionDestroyed(@Observes SessionDestroyedEvent sessionDestroyedEvent) {
        PortablePreconditions.checkNotNull((String)"sessionDestroyedEvent", (Object)sessionDestroyedEvent);
        if (this.isRequestStarted()) {
            LOGGER.log(Level.WARNING, "Current client request has not been completed yet.");
        }
    }

    private void start() {
        if (this.isRequestStarted()) {
            LOGGER.log(Level.WARNING, "Current client request has not been completed yet.A new client request cannot be started!");
            this.clear();
        }
        LOGGER.log(Level.FINEST, "New client request started.");
        this.currentCommandBuilder = new CompositeCommandImpl.CompositeCommandBuilder().forward();
    }

    private void complete() {
        LOGGER.log(Level.FINEST, "Checking if current client request has been completed...");
        if (this.isRequestStarted()) {
            if (this.currentCommandBuilder.size() > 0) {
                LOGGER.log(Level.FINEST, "Adding commands for current request into registry [size=" + this.currentCommandBuilder.size() + "]");
                this.getRegistry().register((Command)this.currentCommandBuilder.build());
            }
            this.clear();
            LOGGER.log(Level.FINEST, "Current client request completed.");
        } else {
            LOGGER.log(Level.WARNING, "Current client request has not been started.");
        }
    }

    private boolean isRequestStarted() {
        return null != this.currentCommandBuilder;
    }

    private void clear() {
        this.currentCommandBuilder = null;
    }
}

