/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.palette.factory;

import com.google.gwt.logging.client.LogConfiguration;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.ShapeSet;
import org.kie.workbench.common.stunner.core.client.api.ShapeManager;
import org.kie.workbench.common.stunner.core.client.components.palette.Palette;
import org.kie.workbench.common.stunner.core.client.components.palette.factory.DefaultDefSetPaletteDefinitionFactory;
import org.kie.workbench.common.stunner.core.client.components.palette.factory.PaletteDefinitionFactory;
import org.kie.workbench.common.stunner.core.client.components.palette.factory.PaletteFactory;
import org.kie.workbench.common.stunner.core.client.components.palette.model.HasPaletteItems;
import org.kie.workbench.common.stunner.core.client.components.palette.model.PaletteDefinitionBuilder;
import org.kie.workbench.common.stunner.core.client.components.palette.view.PaletteGrid;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;

public abstract class AbstractPaletteFactory<I extends HasPaletteItems, P extends Palette<I>>
implements PaletteFactory<I, P> {
    private static Logger LOGGER = Logger.getLogger(AbstractPaletteFactory.class.getName());
    protected final SyncBeanManager beanManager;
    protected final ShapeManager shapeManager;
    protected final DefinitionManager definitionManager;
    protected final List<PaletteDefinitionFactory> paletteDefinitionFactories = new LinkedList<PaletteDefinitionFactory>();
    protected final ManagedInstance<DefaultDefSetPaletteDefinitionFactory> defaultPaletteDefinitionFactoryInstance;

    public AbstractPaletteFactory(ShapeManager shapeManager, SyncBeanManager beanManager, DefinitionManager definitionManager, ManagedInstance<DefaultDefSetPaletteDefinitionFactory> defaultPaletteDefinitionFactoryInstance) {
        this.shapeManager = shapeManager;
        this.beanManager = beanManager;
        this.definitionManager = definitionManager;
        this.defaultPaletteDefinitionFactoryInstance = defaultPaletteDefinitionFactoryInstance;
    }

    public void init() {
        Collection paletteFactoryBeans = this.beanManager.lookupBeans(PaletteDefinitionFactory.class);
        for (SyncBeanDef paletteFactoryBean : paletteFactoryBeans) {
            PaletteDefinitionFactory factory = (PaletteDefinitionFactory)paletteFactoryBean.getInstance();
            this.paletteDefinitionFactories.add(factory);
        }
    }

    protected PaletteDefinitionFactory getPaletteDefinitionFactory(String defSetId) {
        for (PaletteDefinitionFactory factory : this.paletteDefinitionFactories) {
            if (!factory.accepts(defSetId)) continue;
            return factory;
        }
        return (PaletteDefinitionFactory)this.defaultPaletteDefinitionFactoryInstance.get();
    }

    public P newPalette(String shapeSetId) {
        return this.newPalette(shapeSetId, null);
    }

    public P newPalette(final String shapeSetId, final PaletteGrid grid) {
        final String definitionSetId = this.getShapeSet(shapeSetId).getDefinitionSetId();
        Object definitionSet = this.definitionManager.definitionSets().getDefinitionSetById(definitionSetId);
        final Set definitions = this.definitionManager.adapters().forDefinitionSet().getDefinitions(definitionSet);
        PaletteDefinitionFactory paletteDefinitionFactory = this.getPaletteDefinitionFactory(definitionSetId);
        PaletteDefinitionBuilder paletteDefinitionBuilder = paletteDefinitionFactory.newBuilder(definitionSetId);
        final Palette palette = paletteDefinitionFactory.newPalette();
        PaletteDefinitionBuilder.Configuration configuration = new PaletteDefinitionBuilder.Configuration(){

            public String getDefinitionSetId() {
                return definitionSetId;
            }

            public Set<String> getDefinitionIds() {
                return definitions;
            }
        };
        paletteDefinitionBuilder.build((Object)configuration, new PaletteDefinitionBuilder.Callback<I, ClientRuntimeError>(){

            public void onSuccess(I paletteDefinition) {
                AbstractPaletteFactory.this.applyGrid(grid, palette);
                AbstractPaletteFactory.this.beforeBindPalette(paletteDefinition, palette, shapeSetId);
                palette.bind(paletteDefinition);
                AbstractPaletteFactory.this.afterBindPalette(paletteDefinition, palette, shapeSetId);
            }

            public void onError(ClientRuntimeError error) {
                AbstractPaletteFactory.this.logError(error);
            }
        });
        return (P)palette;
    }

    protected void beforeBindPalette(I paletteDefinition, P palette, String shapeSetId) {
    }

    protected void afterBindPalette(I paletteDefinition, P palette, String shapeSetId) {
    }

    protected void applyGrid(PaletteGrid grid, P palette) {
    }

    private ShapeSet getShapeSet(String id) {
        for (ShapeSet set : this.shapeManager.getShapeSets()) {
            if (!set.getId().equals(id)) continue;
            return set;
        }
        return null;
    }

    private void logError(ClientRuntimeError error) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(Level.SEVERE, error.toString());
        }
    }
}

