/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.palette.model.definition.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.components.palette.model.AbstractPaletteDefinitionBuilder;
import org.kie.workbench.common.stunner.core.client.components.palette.model.PaletteDefinitionBuilder;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.DefinitionPaletteItem;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.DefinitionsPalette;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.DefinitionsPaletteBuilder;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.impl.DefinitionPaletteItemImpl;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.impl.DefinitionsPaletteImpl;
import org.kie.workbench.common.stunner.core.client.service.ClientFactoryService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

@Dependent
public class DefinitionsPaletteBuilderImpl
extends AbstractPaletteDefinitionBuilder<PaletteDefinitionBuilder.Configuration, DefinitionsPalette, ClientRuntimeError>
implements DefinitionsPaletteBuilder {
    private final DefinitionUtils definitionUtils;
    private final ClientFactoryService clientFactoryServices;

    protected DefinitionsPaletteBuilderImpl() {
        this(null, null);
    }

    @Inject
    public DefinitionsPaletteBuilderImpl(DefinitionUtils definitionUtils, ClientFactoryService clientFactoryServices) {
        this.definitionUtils = definitionUtils;
        this.clientFactoryServices = clientFactoryServices;
    }

    public void build(PaletteDefinitionBuilder.Configuration configuration, PaletteDefinitionBuilder.Callback<DefinitionsPalette, ClientRuntimeError> callback) {
        String defSetId = configuration.getDefinitionSetId();
        Set definitions = configuration.getDefinitionIds();
        if (null != definitions) {
            LinkedList builders = new LinkedList();
            for (Object definitionId : definitions) {
                if (this.isDefinitionExcluded((String)definitionId)) continue;
                this.clientFactoryServices.newDefinition((String)definitionId, new ServiceCallback<Object>((String)definitionId, builders, callback){
                    final /* synthetic */ String val$definitionId;
                    final /* synthetic */ List val$builders;
                    final /* synthetic */ PaletteDefinitionBuilder.Callback val$callback;
                    {
                        this.val$definitionId = string;
                        this.val$builders = list;
                        this.val$callback = callback;
                    }

                    public void onSuccess(Object definition) {
                        String category = DefinitionsPaletteBuilderImpl.this.getDefinitionManager().adapters().forDefinition().getCategory(definition);
                        String categoryId = DefinitionsPaletteBuilderImpl.this.toValidId(category);
                        if (!DefinitionsPaletteBuilderImpl.this.isCategoryExcluded(categoryId)) {
                            String id = DefinitionsPaletteBuilderImpl.this.toValidId(this.val$definitionId);
                            String title = DefinitionsPaletteBuilderImpl.this.getDefinitionManager().adapters().forDefinition().getTitle(definition);
                            String description = DefinitionsPaletteBuilderImpl.this.getDefinitionManager().adapters().forDefinition().getDescription(definition);
                            DefinitionPaletteItemImpl.DefinitionPaletteItemBuilder itemBuilder = (DefinitionPaletteItemImpl.DefinitionPaletteItemBuilder)((DefinitionPaletteItemImpl.DefinitionPaletteItemBuilder)((DefinitionPaletteItemImpl.DefinitionPaletteItemBuilder)new DefinitionPaletteItemImpl.DefinitionPaletteItemBuilder(id).definitionId(this.val$definitionId).title(title)).description(description)).tooltip(description);
                            this.val$builders.add(itemBuilder);
                        }
                    }

                    public void onError(ClientRuntimeError error) {
                        this.val$callback.onError((Object)error);
                    }
                });
            }
            if (!builders.isEmpty()) {
                LinkedList<DefinitionPaletteItem> paletteItems = new LinkedList<DefinitionPaletteItem>();
                for (DefinitionPaletteItemImpl.DefinitionPaletteItemBuilder builder : builders) {
                    paletteItems.add(builder.build());
                }
                DefinitionsPaletteImpl definitionsPalette = new DefinitionsPaletteImpl((List<DefinitionPaletteItem>)paletteItems, defSetId);
                callback.onSuccess((Object)definitionsPalette);
            } else {
                callback.onError((Object)new ClientRuntimeError("No categories found."));
            }
        } else {
            callback.onError((Object)new ClientRuntimeError("Missing definitions argument."));
        }
    }

    protected DefinitionManager getDefinitionManager() {
        return this.definitionUtils.getDefinitionManager();
    }
}

