/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.toolbox.actions;

import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.api.ClientFactoryManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.BuildRequest;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.BuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.EdgeBuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.request.EdgeBuildRequestImpl;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasHighlight;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.components.drag.ConnectorDragProxy;
import org.kie.workbench.common.stunner.core.client.components.drag.DragProxyCallback;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.AbstractToolboxAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ToolboxAction;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.session.Session;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeFactory;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickEvent;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.index.bounds.GraphBoundsIndexer;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.core.util.UUID;

@Dependent
public class CreateConnectorAction
extends AbstractToolboxAction {
    private static Logger LOGGER = Logger.getLogger(CreateConnectorAction.class.getName());
    static final String KEY_TITLE = "org.kie.workbench.common.stunner.core.client.toolbox.createNewConnector";
    private final ClientFactoryManager clientFactoryManager;
    private final GraphBoundsIndexer graphBoundsIndexer;
    private final ConnectorDragProxy<AbstractCanvasHandler> connectorDragProxyFactory;
    private final EdgeBuilderControl<AbstractCanvasHandler> edgeBuilderControl;
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private final Function<AbstractCanvasHandler, CanvasHighlight> canvasHighlightBuilder;
    private String edgeId;
    private CanvasHighlight canvasHighlight;

    @Inject
    public CreateConnectorAction(DefinitionUtils definitionUtils, ClientFactoryManager clientFactoryManager, GraphBoundsIndexer graphBoundsIndexer, ConnectorDragProxy<AbstractCanvasHandler> connectorDragProxyFactory, EdgeBuilderControl<AbstractCanvasHandler> edgeBuilderControl, @Session SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, ClientTranslationService translationService) {
        this(definitionUtils, clientFactoryManager, graphBoundsIndexer, connectorDragProxyFactory, edgeBuilderControl, sessionCommandManager, translationService, CanvasHighlight::new);
    }

    CreateConnectorAction(DefinitionUtils definitionUtils, ClientFactoryManager clientFactoryManager, GraphBoundsIndexer graphBoundsIndexer, ConnectorDragProxy<AbstractCanvasHandler> connectorDragProxyFactory, EdgeBuilderControl<AbstractCanvasHandler> edgeBuilderControl, @Session SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, ClientTranslationService translationService, Function<AbstractCanvasHandler, CanvasHighlight> canvasHighlightBuilder) {
        super(definitionUtils, translationService);
        this.clientFactoryManager = clientFactoryManager;
        this.graphBoundsIndexer = graphBoundsIndexer;
        this.connectorDragProxyFactory = connectorDragProxyFactory;
        this.edgeBuilderControl = edgeBuilderControl;
        this.sessionCommandManager = sessionCommandManager;
        this.canvasHighlightBuilder = canvasHighlightBuilder;
    }

    public CreateConnectorAction setEdgeId(String edgeId) {
        this.edgeId = edgeId;
        return this;
    }

    public String getEdgeId() {
        return this.edgeId;
    }

    @Override
    public ToolboxAction<AbstractCanvasHandler> onMouseClick(AbstractCanvasHandler canvasHandler, String uuid, MouseClickEvent event) {
        Element<?> element = CreateConnectorAction.getElement(canvasHandler, uuid);
        Node sourceNode = element.asNode();
        Edge connector = this.clientFactoryManager.newElement(UUID.uuid(), this.edgeId).asEdge();
        connector.setSourceNode(sourceNode);
        double x = event.getX();
        double y = event.getY();
        this.showDragProxy(canvasHandler, connector, sourceNode, (int)x, (int)y);
        return this;
    }

    @Override
    protected String getTitleKey(AbstractCanvasHandler canvasHandler, String uuid) {
        return KEY_TITLE;
    }

    @Override
    protected String getTitleDefinitionId(AbstractCanvasHandler canvasHandler, String uuid) {
        return this.edgeId;
    }

    @Override
    protected String getGlyphId(AbstractCanvasHandler canvasHandler, String uuid) {
        return this.edgeId;
    }

    private void showDragProxy(final AbstractCanvasHandler canvasHandler, final Edge<View<?>, Node> connector, final Node<View<?>, Edge> sourceNode, int x, int y) {
        String ssid = canvasHandler.getDiagram().getMetadata().getShapeSetId();
        final ShapeFactory<Object, Shape> shapeFactory = canvasHandler.getShapeFactory(ssid);
        ConnectorDragProxy.Item connectorDragItem = new ConnectorDragProxy.Item(){

            public Edge<View<?>, Node> getEdge() {
                return connector;
            }

            public Node<View<?>, Edge> getSourceNode() {
                return sourceNode;
            }

            public ShapeFactory<?, ?> getShapeFactory() {
                return shapeFactory;
            }
        };
        this.connectorDragProxyFactory.proxyFor((Object)canvasHandler).show((Object)connectorDragItem, x, y, (Object)new DragProxyCallback(){

            public void onStart(int x, int y) {
                CreateConnectorAction.this.start(canvasHandler);
            }

            public void onMove(int x, int y) {
                Node targetNode = (Node)CreateConnectorAction.this.graphBoundsIndexer.getAt((double)x, (double)y);
                boolean allow = CreateConnectorAction.this.allow(x, y, connector, sourceNode, targetNode);
                CreateConnectorAction.this.canvasHighlight.unhighLight();
                if (null != targetNode && allow) {
                    CreateConnectorAction.this.canvasHighlight.highLight((Element<?>)targetNode);
                } else if (null != targetNode) {
                    CreateConnectorAction.this.canvasHighlight.invalid((Element<?>)targetNode);
                }
            }

            public void onComplete(int x, int y) {
                Node targetNode = (Node)CreateConnectorAction.this.graphBoundsIndexer.getAt((double)x, (double)y);
                CreateConnectorAction.this.accept(x, y, connector, sourceNode, targetNode);
            }
        });
    }

    private void start(AbstractCanvasHandler canvasHandler) {
        this.canvasHighlight = this.canvasHighlightBuilder.apply(canvasHandler);
        this.graphBoundsIndexer.setRootUUID(canvasHandler.getDiagram().getMetadata().getCanvasRootUUID());
        this.graphBoundsIndexer.build((Object)canvasHandler.getDiagram().getGraph());
        this.edgeBuilderControl.enable((Object)canvasHandler);
        this.edgeBuilderControl.setCommandManagerProvider(() -> this.sessionCommandManager);
    }

    private boolean allow(int x, int y, Edge<View<?>, Node> connector, Node<View<?>, Edge> sourceNode, Node targetNode) {
        if (null != targetNode) {
            EdgeBuildRequestImpl buildRequest = new EdgeBuildRequestImpl(x, y, connector, sourceNode, targetNode);
            return this.edgeBuilderControl.allows((BuildRequest)buildRequest);
        }
        return false;
    }

    private void accept(int x, int y, Edge<View<?>, Node> connector, Node<View<?>, Edge> sourceNode, Node targetNode) {
        if (null != targetNode) {
            EdgeBuildRequestImpl buildRequest = new EdgeBuildRequestImpl(x, y, connector, sourceNode, targetNode);
            this.edgeBuilderControl.build((BuildRequest)buildRequest, new BuilderControl.BuildCallback(){

                public void onSuccess(String uuid) {
                    CreateConnectorAction.this.complete();
                }

                public void onError(ClientRuntimeError error) {
                    CreateConnectorAction.this.error(error);
                }
            });
        }
    }

    private void complete() {
        this.edgeBuilderControl.setCommandManagerProvider(null);
        this.edgeBuilderControl.disable();
        this.canvasHighlight.destroy();
    }

    private void error(ClientRuntimeError error) {
        this.complete();
        LOGGER.log(Level.SEVERE, error.toString());
    }

    CanvasHighlight getCanvasHighlight() {
        return this.canvasHighlight;
    }

    public int hashCode() {
        return this.edgeId.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof CreateConnectorAction) {
            CreateConnectorAction other = (CreateConnectorAction)o;
            return other.edgeId.equals(this.edgeId);
        }
        return false;
    }
}

