/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.toolbox.actions;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.api.ClientFactoryManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.BuildRequest;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.BuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.NodeBuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.request.NodeBuildRequestImpl;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasElementSelectedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasLayoutUtils;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.AbstractToolboxAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ToolboxAction;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.session.Session;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickEvent;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.MagnetConnection;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.core.util.HashUtil;
import org.kie.workbench.common.stunner.core.util.UUID;

@Dependent
public class CreateNodeAction
extends AbstractToolboxAction {
    private static Logger LOGGER = Logger.getLogger(CreateNodeAction.class.getName());
    static final String KEY_TITLE = "org.kie.workbench.common.stunner.core.client.toolbox.createNewNode";
    private final ClientFactoryManager clientFactoryManager;
    private final NodeBuilderControl<AbstractCanvasHandler> nodeBuilderControl;
    private final CanvasLayoutUtils canvasLayoutUtils;
    private final Event<CanvasElementSelectedEvent> elementSelectedEvent;
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private String nodeId;
    private String edgeId;

    @Inject
    public CreateNodeAction(DefinitionUtils definitionUtils, ClientFactoryManager clientFactoryManager, NodeBuilderControl<AbstractCanvasHandler> nodeBuilderControl, CanvasLayoutUtils canvasLayoutUtils, Event<CanvasElementSelectedEvent> elementSelectedEvent, ClientTranslationService translationService, @Session SessionCommandManager<AbstractCanvasHandler> sessionCommandManager) {
        super(definitionUtils, translationService);
        this.clientFactoryManager = clientFactoryManager;
        this.nodeBuilderControl = nodeBuilderControl;
        this.canvasLayoutUtils = canvasLayoutUtils;
        this.elementSelectedEvent = elementSelectedEvent;
        this.sessionCommandManager = sessionCommandManager;
    }

    public CreateNodeAction setNodeId(String nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public CreateNodeAction setEdgeId(String edgeId) {
        this.edgeId = edgeId;
        return this;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getEdgeId() {
        return this.edgeId;
    }

    @Override
    protected String getTitleKey(AbstractCanvasHandler canvasHandler, String uuid) {
        return KEY_TITLE;
    }

    @Override
    protected String getTitleDefinitionId(AbstractCanvasHandler canvasHandler, String uuid) {
        return this.nodeId;
    }

    @Override
    protected String getGlyphId(AbstractCanvasHandler canvasHandler, String uuid) {
        return this.nodeId;
    }

    @Override
    public ToolboxAction<AbstractCanvasHandler> onMouseClick(final AbstractCanvasHandler canvasHandler, String uuid, MouseClickEvent event) {
        Element<?> element = CreateNodeAction.getElement(canvasHandler, uuid);
        Node sourceNode = element.asNode();
        Edge connector = this.clientFactoryManager.newElement(UUID.uuid(), this.edgeId).asEdge();
        Node targetNode = this.clientFactoryManager.newElement(UUID.uuid(), this.nodeId).asNode();
        connector.setSourceNode(sourceNode);
        connector.setTargetNode(targetNode);
        double[] location = this.canvasLayoutUtils.getNext((CanvasHandler)canvasHandler, sourceNode, targetNode);
        MagnetConnection sourceConnection = MagnetConnection.Builder.forElement(element);
        MagnetConnection targetConnection = MagnetConnection.Builder.forElement((Element)targetNode);
        NodeBuildRequestImpl buildRequest = new NodeBuildRequestImpl(location[0], location[1], targetNode, connector, (Connection)sourceConnection, (Connection)targetConnection);
        this.start(canvasHandler);
        this.nodeBuilderControl.build((BuildRequest)buildRequest, new BuilderControl.BuildCallback(){

            public void onSuccess(String newNodeUUID) {
                AbstractToolboxAction.fireElementSelectedEvent((Event<CanvasElementSelectedEvent>)CreateNodeAction.this.elementSelectedEvent, canvasHandler, newNodeUUID);
                CreateNodeAction.this.complete();
            }

            public void onError(ClientRuntimeError error) {
                CreateNodeAction.this.error(error);
            }
        });
        return this;
    }

    private void start(AbstractCanvasHandler canvasHandler) {
        this.nodeBuilderControl.enable((Object)canvasHandler);
        this.nodeBuilderControl.setCommandManagerProvider(() -> this.sessionCommandManager);
    }

    private void complete() {
        this.nodeBuilderControl.setCommandManagerProvider(null);
        this.nodeBuilderControl.disable();
    }

    private void error(ClientRuntimeError error) {
        this.complete();
        LOGGER.log(Level.SEVERE, error.toString());
    }

    public int hashCode() {
        return HashUtil.combineHashCodes((int[])new int[]{this.edgeId.hashCode(), this.nodeId.hashCode()});
    }

    public boolean equals(Object o) {
        if (o instanceof CreateNodeAction) {
            CreateNodeAction other = (CreateNodeAction)o;
            return other.edgeId.equals(this.edgeId) && other.nodeId.equals(this.nodeId);
        }
        return false;
    }
}

