/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.toolbox.actions;

import com.google.gwt.user.client.Window;
import java.util.function.Predicate;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.AbstractToolboxAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ToolboxAction;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.resources.StunnerCommonImageResources;
import org.kie.workbench.common.stunner.core.client.session.Session;
import org.kie.workbench.common.stunner.core.client.shape.SvgDataUriGlyph;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickEvent;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.definition.shape.Glyph;
import org.kie.workbench.common.stunner.core.graph.Node;

@Dependent
public class DeleteNodeAction
implements ToolboxAction<AbstractCanvasHandler> {
    private final ClientTranslationService translationService;
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private final CanvasCommandFactory<AbstractCanvasHandler> commandFactory;
    private final Predicate<DeleteNodeAction> confirmDelete;
    private static final SvgDataUriGlyph GLYPH = SvgDataUriGlyph.Builder.build(StunnerCommonImageResources.INSTANCE.delete().getSafeUri());

    @Inject
    public DeleteNodeAction(ClientTranslationService translationService, @Session SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, CanvasCommandFactory<AbstractCanvasHandler> commandFactory) {
        this(translationService, sessionCommandManager, commandFactory, deleteNodeAction -> Window.confirm((String)translationService.getKeyValue("org.kie.workbench.common.stunner.core.areYouSure")));
    }

    DeleteNodeAction(ClientTranslationService translationService, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, CanvasCommandFactory<AbstractCanvasHandler> commandFactory, Predicate<DeleteNodeAction> confirmDelete) {
        this.translationService = translationService;
        this.sessionCommandManager = sessionCommandManager;
        this.commandFactory = commandFactory;
        this.confirmDelete = confirmDelete;
    }

    @Override
    public Glyph getGlyph(AbstractCanvasHandler canvasHandler, String uuid) {
        return GLYPH;
    }

    @Override
    public String getTitle(AbstractCanvasHandler canvasHandler, String uuid) {
        return this.translationService.getKeyValue("org.kie.workbench.common.stunner.core.delete");
    }

    @Override
    public ToolboxAction<AbstractCanvasHandler> onMouseClick(AbstractCanvasHandler canvasHandler, String uuid, MouseClickEvent event) {
        if (this.confirmDelete.test(this)) {
            Node node = AbstractToolboxAction.getElement(canvasHandler, uuid).asNode();
            this.sessionCommandManager.execute((Object)canvasHandler, (Command)this.commandFactory.deleteNode(node));
        }
        return this;
    }
}

