/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.toolbox.actions;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.AbstractActionsToolboxFactory;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ActionsToolboxView;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.CreateConnectorAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.CreateNodeAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.FlowActionsToolbox;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ToolboxAction;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.lookup.util.CommonLookups;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

@ApplicationScoped
@FlowActionsToolbox
public class FlowActionsToolboxFactory
extends AbstractActionsToolboxFactory {
    private final DefinitionUtils definitionUtils;
    private final CommonLookups commonLookups;
    private final Supplier<CreateConnectorAction> createConnectorActions;
    private final Supplier<CreateNodeAction> createNodeActions;
    private final Supplier<ActionsToolboxView> views;

    @Inject
    public FlowActionsToolboxFactory(DefinitionUtils definitionUtils, CommonLookups commonLookups, @Any ManagedInstance<CreateConnectorAction> createConnectorActions, @Any ManagedInstance<CreateNodeAction> createNodeActions, @FlowActionsToolbox ManagedInstance<ActionsToolboxView> views) {
        this(definitionUtils, commonLookups, () -> createConnectorActions.get(), () -> createNodeActions.get(), () -> views.get());
    }

    FlowActionsToolboxFactory(DefinitionUtils definitionUtils, CommonLookups commonLookups, Supplier<CreateConnectorAction> createConnectorActions, Supplier<CreateNodeAction> createNodeActions, Supplier<ActionsToolboxView> views) {
        this.definitionUtils = definitionUtils;
        this.commonLookups = commonLookups;
        this.createConnectorActions = createConnectorActions;
        this.createNodeActions = createNodeActions;
        this.views = views;
    }

    @Override
    protected ActionsToolboxView<?> newViewInstance() {
        return this.views.get();
    }

    @Override
    public Collection<ToolboxAction<AbstractCanvasHandler>> getActions(AbstractCanvasHandler canvasHandler, Element<?> element) {
        LinkedHashSet<ToolboxAction<AbstractCanvasHandler>> actions = new LinkedHashSet<ToolboxAction<AbstractCanvasHandler>>();
        Node node = (Node)element;
        Diagram diagram = canvasHandler.getDiagram();
        String defSetId = diagram.getMetadata().getDefinitionSetId();
        this.commonLookups.getAllowedConnectors(defSetId, node, 0, 10).forEach(connectorDefId -> actions.add(this.createConnectorActions.get().setEdgeId((String)connectorDefId)));
        String defaultConnectorId = this.definitionUtils.getDefaultConnectorId(defSetId);
        if (null != defaultConnectorId) {
            this.commonLookups.getAllowedMorphDefaultDefinitions(defSetId, diagram.getGraph(), node, defaultConnectorId, 0, 10).forEach(defId -> actions.add(this.createNodeActions.get().setEdgeId(defaultConnectorId).setNodeId(defId.toString())));
        }
        return actions;
    }
}

