/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.toolbox.actions;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.AbstractActionsToolboxFactory;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ActionsToolboxView;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.MorphActionsToolbox;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.MorphNodeAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ToolboxAction;
import org.kie.workbench.common.stunner.core.definition.adapter.MorphAdapter;
import org.kie.workbench.common.stunner.core.definition.morph.MorphDefinition;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

@ApplicationScoped
@MorphActionsToolbox
public class MorphActionsToolboxFactory
extends AbstractActionsToolboxFactory {
    private final DefinitionUtils definitionUtils;
    private final Supplier<MorphNodeAction> morphNodeActions;
    private final Supplier<ActionsToolboxView> views;

    @Inject
    public MorphActionsToolboxFactory(DefinitionUtils definitionUtils, @Any ManagedInstance<MorphNodeAction> morphNodeActions, @MorphActionsToolbox ManagedInstance<ActionsToolboxView> views) {
        this(definitionUtils, () -> morphNodeActions.get(), () -> views.get());
    }

    MorphActionsToolboxFactory(DefinitionUtils definitionUtils, Supplier<MorphNodeAction> morphNodeActions, Supplier<ActionsToolboxView> views) {
        this.definitionUtils = definitionUtils;
        this.morphNodeActions = morphNodeActions;
        this.views = views;
    }

    private DefinitionManager getDefinitionManager() {
        return this.definitionUtils.getDefinitionManager();
    }

    @Override
    protected ActionsToolboxView<?> newViewInstance() {
        return this.views.get();
    }

    @Override
    public Collection<ToolboxAction<AbstractCanvasHandler>> getActions(AbstractCanvasHandler canvasHandler, Element<?> e) {
        Element<?> element;
        Object definition;
        LinkedHashSet<ToolboxAction<AbstractCanvasHandler>> actions = new LinkedHashSet<ToolboxAction<AbstractCanvasHandler>>();
        if (null != e.asNode() && this.definitionUtils.hasMorphTargets(definition = ((Definition)(element = e).getContent()).getDefinition())) {
            String id = this.getDefinitionManager().adapters().forDefinition().getId(definition);
            MorphAdapter morphAdapter = this.getDefinitionManager().adapters().registry().getMorphAdapter(definition.getClass());
            Iterable morphDefinitions = morphAdapter.getMorphDefinitions(definition);
            if (null != morphDefinitions && morphDefinitions.iterator().hasNext()) {
                LinkedHashMap<String, MorphDefinition> definitionMap = new LinkedHashMap<String, MorphDefinition>();
                for (MorphDefinition morphDefinition2 : morphDefinitions) {
                    Iterable morphTargets = morphAdapter.getTargets(definition, morphDefinition2);
                    if (null == morphTargets || !morphTargets.iterator().hasNext()) continue;
                    for (String morphTarget : morphTargets) {
                        if (id.equals(morphTarget)) continue;
                        definitionMap.put(morphTarget, morphDefinition2);
                    }
                }
                definitionMap.forEach((targetMorphId, morphDefinition) -> actions.add(this.morphNodeActions.get().setMorphDefinition((MorphDefinition)morphDefinition).setTargetDefinitionId((String)targetMorphId)));
            }
        }
        return actions;
    }
}

