/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.toolbox.actions;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasElementSelectedEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.AbstractToolboxAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ToolboxAction;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.session.Session;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickEvent;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.definition.morph.MorphDefinition;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.core.util.HashUtil;

@Dependent
public class MorphNodeAction
extends AbstractToolboxAction {
    private static Logger LOGGER = Logger.getLogger(MorphNodeAction.class.getName());
    static final String KEY_TITLE = "org.kie.workbench.common.stunner.core.client.toolbox.morphInto";
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private final CanvasCommandFactory<AbstractCanvasHandler> commandFactory;
    private final Event<CanvasElementSelectedEvent> elementSelectedEvent;
    private MorphDefinition morphDefinition;
    private String targetDefinitionId;

    @Inject
    public MorphNodeAction(DefinitionUtils definitionUtils, @Session SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, CanvasCommandFactory<AbstractCanvasHandler> commandFactory, ClientTranslationService translationService, Event<CanvasElementSelectedEvent> elementSelectedEvent) {
        super(definitionUtils, translationService);
        this.sessionCommandManager = sessionCommandManager;
        this.commandFactory = commandFactory;
        this.elementSelectedEvent = elementSelectedEvent;
    }

    public MorphNodeAction setMorphDefinition(MorphDefinition morphDefinition) {
        this.morphDefinition = morphDefinition;
        return this;
    }

    public MorphNodeAction setTargetDefinitionId(String targetDefinitionId) {
        this.targetDefinitionId = targetDefinitionId;
        return this;
    }

    @Override
    public ToolboxAction<AbstractCanvasHandler> onMouseClick(AbstractCanvasHandler canvasHandler, String uuid, MouseClickEvent event) {
        String ssid = canvasHandler.getDiagram().getMetadata().getShapeSetId();
        Node sourceNode = MorphNodeAction.getElement(canvasHandler, uuid).asNode();
        CommandResult result = this.sessionCommandManager.execute((Object)canvasHandler, (Command)this.commandFactory.morphNode(sourceNode, this.morphDefinition, this.targetDefinitionId, ssid));
        if (CommandUtils.isError((CommandResult)result)) {
            LOGGER.log(Level.SEVERE, result.toString());
        } else {
            MorphNodeAction.fireElementSelectedEvent(this.elementSelectedEvent, canvasHandler, uuid);
        }
        return this;
    }

    @Override
    protected String getTitleKey(AbstractCanvasHandler canvasHandler, String uuid) {
        return KEY_TITLE;
    }

    @Override
    protected String getTitleDefinitionId(AbstractCanvasHandler canvasHandler, String uuid) {
        return this.targetDefinitionId;
    }

    @Override
    protected String getGlyphId(AbstractCanvasHandler canvasHandler, String uuid) {
        return this.targetDefinitionId;
    }

    public int hashCode() {
        return HashUtil.combineHashCodes((int[])new int[]{this.morphDefinition.hashCode(), this.targetDefinitionId.hashCode()});
    }

    public boolean equals(Object o) {
        if (o instanceof MorphNodeAction) {
            MorphNodeAction other = (MorphNodeAction)o;
            return other.morphDefinition.equals(this.morphDefinition) && other.targetDefinitionId.equals(this.targetDefinitionId);
        }
        return false;
    }
}

