/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.definition.adapter.binding;

import java.util.LinkedHashMap;
import java.util.Map;
import org.kie.workbench.common.stunner.core.client.definition.adapter.binding.AbstractClientBindableAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindablePropertyAdapter;
import org.kie.workbench.common.stunner.core.definition.property.PropertyType;
import org.kie.workbench.common.stunner.core.i18n.StunnerTranslationService;

class ClientBindablePropertyAdapter
extends AbstractClientBindableAdapter<Object>
implements BindablePropertyAdapter<Object, Object> {
    private Map<Class, String> propertyTypeFieldNames;
    private Map<Class, String> propertyCaptionFieldNames;
    private Map<Class, String> propertyDescriptionFieldNames;
    private Map<Class, String> propertyReadOnlyFieldNames;
    private Map<Class, String> propertyOptionalFieldNames;
    private Map<Class, String> propertyValueFieldNames;
    private Map<Class, String> propertyDefaultValueFieldNames;
    private Map<Class, String> propertyAllowedValuesFieldNames;

    public ClientBindablePropertyAdapter(StunnerTranslationService translationService) {
        super(translationService);
    }

    public void setBindings(Map<Class, String> propertyTypeFieldNames, Map<Class, String> propertyCaptionFieldNames, Map<Class, String> propertyDescriptionFieldNames, Map<Class, String> propertyReadOnlyFieldNames, Map<Class, String> propertyOptionalFieldNames, Map<Class, String> propertyValueFieldNames, Map<Class, String> propertyDefaultValueFieldNames, Map<Class, String> propertyAllowedValuesFieldNames) {
        this.propertyTypeFieldNames = propertyTypeFieldNames;
        this.propertyCaptionFieldNames = propertyCaptionFieldNames;
        this.propertyDescriptionFieldNames = propertyDescriptionFieldNames;
        this.propertyReadOnlyFieldNames = propertyReadOnlyFieldNames;
        this.propertyOptionalFieldNames = propertyOptionalFieldNames;
        this.propertyValueFieldNames = propertyValueFieldNames;
        this.propertyDefaultValueFieldNames = propertyDefaultValueFieldNames;
        this.propertyAllowedValuesFieldNames = propertyAllowedValuesFieldNames;
    }

    public String getId(Object pojo) {
        return BindableAdapterUtils.getPropertyId(pojo.getClass());
    }

    public PropertyType getType(Object pojo) {
        return (PropertyType)this.getProxiedValue(pojo, this.getPropertyTypeFieldNames().get(pojo.getClass()));
    }

    public String getCaption(Object pojo) {
        String caption = this.translationService.getPropertyCaption(pojo.getClass().getName());
        if (caption != null) {
            return caption;
        }
        return (String)this.getProxiedValue(pojo, this.getPropertyCaptionFieldNames().get(pojo.getClass()));
    }

    public String getDescription(Object pojo) {
        String description = this.translationService.getPropertyDescription(pojo.getClass().getName());
        if (description != null) {
            return description;
        }
        return (String)this.getProxiedValue(pojo, this.getPropertyDescriptionFieldNames().get(pojo.getClass()));
    }

    public boolean isReadOnly(Object pojo) {
        return (Boolean)this.getProxiedValue(pojo, this.getPropertyReadOnlyFieldNames().get(pojo.getClass()));
    }

    public boolean isOptional(Object pojo) {
        return (Boolean)this.getProxiedValue(pojo, this.getPropertyOptionalFieldNames().get(pojo.getClass()));
    }

    public Object getValue(Object pojo) {
        return this.getProxiedValue(pojo, this.getPropertyValueFieldNames().get(pojo.getClass()));
    }

    public Object getDefaultValue(Object pojo) {
        return this.getProxiedValue(pojo, this.getPropertyDefaultValueFieldNames().get(pojo.getClass()));
    }

    public void setValue(Object pojo, Object value) {
        if (this.isReadOnly(pojo)) {
            throw new RuntimeException("Cannot set new value for property [" + this.getId(pojo) + "] as it is read only! ");
        }
        this.setProxiedValue(pojo, this.getPropertyValueFieldNames().get(pojo.getClass()), value);
    }

    public Map<Object, String> getAllowedValues(Object pojo) {
        Iterable result = (Iterable)this.getProxiedValue(pojo, this.getPropertyAllowedValuesFieldNames().get(pojo.getClass()));
        if (null != result) {
            LinkedHashMap<Object, String> allowedValues = new LinkedHashMap<Object, String>();
            for (Object o : result) {
                allowedValues.put(o, o.toString());
            }
            return allowedValues;
        }
        return null;
    }

    public boolean accepts(Class<?> pojoClass) {
        if (null != this.propertyValueFieldNames) {
            return this.getPropertyValueFieldNames().containsKey(pojoClass);
        }
        return false;
    }

    private Map<Class, String> getPropertyTypeFieldNames() {
        return this.propertyTypeFieldNames;
    }

    private Map<Class, String> getPropertyCaptionFieldNames() {
        return this.propertyCaptionFieldNames;
    }

    private Map<Class, String> getPropertyDescriptionFieldNames() {
        return this.propertyDescriptionFieldNames;
    }

    private Map<Class, String> getPropertyReadOnlyFieldNames() {
        return this.propertyReadOnlyFieldNames;
    }

    private Map<Class, String> getPropertyOptionalFieldNames() {
        return this.propertyOptionalFieldNames;
    }

    private Map<Class, String> getPropertyValueFieldNames() {
        return this.propertyValueFieldNames;
    }

    private Map<Class, String> getPropertyDefaultValueFieldNames() {
        return this.propertyDefaultValueFieldNames;
    }

    private Map<Class, String> getPropertyAllowedValuesFieldNames() {
        return this.propertyAllowedValuesFieldNames;
    }
}

