/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.event.keyboard;

import com.google.gwt.user.client.Timer;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import org.kie.workbench.common.stunner.core.client.event.keyboard.KeyDownEvent;
import org.kie.workbench.common.stunner.core.client.event.keyboard.KeyUpEvent;
import org.kie.workbench.common.stunner.core.client.event.keyboard.KeyboardEvent;
import org.uberfire.commons.validation.PortablePreconditions;

@Dependent
public class ClientKeyShortcutsHandler {
    private static final int KEYS_TIMER_DELAY = 250;
    private final List<KeyboardEvent.Key> keys = new ArrayList<KeyboardEvent.Key>();
    private KeyShortcutCallback shortcutCallback;
    private KeyboardEvent.Key[] _keys;
    private Timer timer;

    public void setKeyShortcutCallback(KeyShortcutCallback shortcutCallback) {
        this.shortcutCallback = shortcutCallback;
    }

    public static boolean isSameShortcut(KeyboardEvent.Key[] keys1, KeyboardEvent.Key ... keys2) {
        for (int i = 0; i < keys1.length; ++i) {
            if (keys2[i].equals((Object)keys1[i])) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        if (null != this.timer && this.timer.isRunning()) {
            this.timer.cancel();
            this.timer = null;
        }
        this.shortcutCallback = null;
        this.keys.clear();
        this._keys = null;
    }

    void onKeyUpEvent(@Observes KeyUpEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        this.onKeyUp(event.getKey());
    }

    void onKeyDownEvent(@Observes KeyDownEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        this.onKeyDown(event.getKey());
    }

    private void onKeyDown(KeyboardEvent.Key key) {
        if (null != this.shortcutCallback) {
            this.startKeysTimer(key);
        }
    }

    private void onKeyUp(KeyboardEvent.Key key) {
        this.keys.remove(key);
    }

    private void startKeysTimer(KeyboardEvent.Key key) {
        this.keys.add(key);
        this._keys = this.keys.toArray(new KeyboardEvent.Key[this.keys.size()]);
        if (null == this.timer) {
            this.timer = new Timer(){

                public void run() {
                    ClientKeyShortcutsHandler.this.keysTimerTimeIsUp();
                }
            };
        }
        this.timer.schedule(250);
    }

    void keysTimerTimeIsUp() {
        if (null != this.shortcutCallback && null != this._keys) {
            this.shortcutCallback.onKeyShortcut(this._keys);
        }
        this._keys = null;
        this.timer.cancel();
        this.timer = null;
    }

    public static interface KeyShortcutCallback {
        public void onKeyShortcut(KeyboardEvent.Key ... var1);
    }
}

