/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.event.keyboard;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.event.keyboard.ClientKeyShortcutsHandler;
import org.kie.workbench.common.stunner.core.client.event.keyboard.KeyboardEvent;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;

@Dependent
public class SessionKeyShortcutsHandler {
    private final SessionManager clientSessionManager;
    private final ClientKeyShortcutsHandler keyShortcutsHandler;
    private ClientSession session;

    @Inject
    public SessionKeyShortcutsHandler(SessionManager clientSessionManager, ClientKeyShortcutsHandler keyShortcutsHandler) {
        this.clientSessionManager = clientSessionManager;
        this.keyShortcutsHandler = keyShortcutsHandler;
    }

    public SessionKeyShortcutsHandler setKeyShortcutCallback(ClientKeyShortcutsHandler.KeyShortcutCallback shortcutCallback) {
        this.keyShortcutsHandler.setKeyShortcutCallback(new SessionKeyShortcutCallback(shortcutCallback));
        return this;
    }

    public SessionKeyShortcutsHandler bind(ClientSession session) {
        this.session = session;
        return this;
    }

    public SessionKeyShortcutsHandler unbind() {
        this.session = null;
        return this;
    }

    private boolean isSameSession(ClientSession session) {
        return null != session && session.equals(this.clientSessionManager.getCurrentSession());
    }

    class SessionKeyShortcutCallback
    implements ClientKeyShortcutsHandler.KeyShortcutCallback {
        private final ClientKeyShortcutsHandler.KeyShortcutCallback delegate;

        private SessionKeyShortcutCallback(ClientKeyShortcutsHandler.KeyShortcutCallback delegate) {
            this.delegate = delegate;
        }

        @Override
        public void onKeyShortcut(KeyboardEvent.Key ... keys) {
            if (SessionKeyShortcutsHandler.this.isSameSession(SessionKeyShortcutsHandler.this.session)) {
                this.delegate.onKeyShortcut(keys);
            }
        }

        public ClientKeyShortcutsHandler.KeyShortcutCallback getDelegate() {
            return this.delegate;
        }
    }
}

