/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.command.impl;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.command.CanvasCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.command.CanvasUndoCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.ClientFullSession;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.Session;
import org.kie.workbench.common.stunner.core.client.session.command.AbstractClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.uberfire.commons.validation.PortablePreconditions;

@Dependent
public class ClearSessionCommand
extends AbstractClientSessionCommand<ClientFullSession> {
    private static Logger LOGGER = Logger.getLogger(ClearSessionCommand.class.getName());
    private final CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory;
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;

    protected ClearSessionCommand() {
        this(null, null);
    }

    @Inject
    public ClearSessionCommand(CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory, @Session SessionCommandManager<AbstractCanvasHandler> sessionCommandManager) {
        super(false);
        this.canvasCommandFactory = canvasCommandFactory;
        this.sessionCommandManager = sessionCommandManager;
    }

    @Override
    public AbstractClientSessionCommand<ClientFullSession> bind(ClientFullSession session) {
        super.bind((ClientSession)session);
        this.checkState();
        return this;
    }

    @Override
    public <V> void execute(ClientSessionCommand.Callback<V> callback) {
        PortablePreconditions.checkNotNull((String)"callback", callback);
        CommandResult result = ((ClientFullSession)this.getSession()).getCommandManager().execute((Object)((ClientFullSession)this.getSession()).getCanvasHandler(), (Command)this.canvasCommandFactory.clearCanvas());
        if (!CommandUtils.isError((CommandResult)result)) {
            this.cleanSessionRegistry();
            callback.onSuccess();
        } else {
            callback.onError(result);
        }
    }

    private void cleanSessionRegistry() {
        LOGGER.log(Level.FINE, "Clear Session Command executed - Cleaning the session's command registry...");
        this.sessionCommandManager.getRegistry().clear();
    }

    void onCommandExecuted(@Observes CanvasCommandExecutedEvent commandExecutedEvent) {
        PortablePreconditions.checkNotNull((String)"commandExecutedEvent", (Object)commandExecutedEvent);
        this.checkState();
    }

    void onCommandUndoExecuted(@Observes CanvasUndoCommandExecutedEvent commandUndoExecutedEvent) {
        PortablePreconditions.checkNotNull((String)"commandUndoExecutedEvent", (Object)commandUndoExecutedEvent);
        this.checkState();
    }

    private void checkState() {
        this.setEnabled(this.getState());
        this.fire();
    }

    private boolean getState() {
        Graph graph;
        Diagram diagram;
        boolean doEnable = false;
        Diagram diagram2 = diagram = null != this.getSession() ? ((ClientFullSession)this.getSession()).getCanvasHandler().getDiagram() : null;
        if (null != diagram && null != (graph = diagram.getGraph())) {
            boolean hasNodes;
            String rootUUID = diagram.getMetadata().getCanvasRootUUID();
            Iterable nodes = graph.nodes();
            boolean bl = hasNodes = null != nodes && nodes.iterator().hasNext();
            if (hasNodes) {
                Iterator nodesIt = nodes.iterator();
                Node node = (Node)nodesIt.next();
                doEnable = nodesIt.hasNext() ? true : null == rootUUID || !rootUUID.equals(node.getUUID());
            }
        }
        return doEnable;
    }
}

