/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.command.impl;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.command.CanvasCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.command.CanvasUndoCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.event.keyboard.ClientKeyShortcutsHandler;
import org.kie.workbench.common.stunner.core.client.event.keyboard.KeyboardEvent;
import org.kie.workbench.common.stunner.core.client.event.keyboard.SessionKeyShortcutsHandler;
import org.kie.workbench.common.stunner.core.client.session.ClientFullSession;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.Session;
import org.kie.workbench.common.stunner.core.client.session.command.AbstractClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.RedoCommandHandler;
import org.uberfire.commons.validation.PortablePreconditions;

@Dependent
public class RedoSessionCommand
extends AbstractClientSessionCommand<ClientFullSession> {
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private final RedoCommandHandler<Command<AbstractCanvasHandler, CanvasViolation>> redoCommandHandler;
    private final SessionKeyShortcutsHandler keyboardListener;

    protected RedoSessionCommand() {
        this(null, null, null);
    }

    @Inject
    public RedoSessionCommand(@Session SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, RedoCommandHandler<Command<AbstractCanvasHandler, CanvasViolation>> redoCommandHandler, SessionKeyShortcutsHandler keyboardListener) {
        super(false);
        this.redoCommandHandler = redoCommandHandler;
        this.sessionCommandManager = sessionCommandManager;
        this.keyboardListener = keyboardListener;
    }

    @PostConstruct
    public void init() {
        this.keyboardListener.setKeyShortcutCallback(keys -> {
            if (this.isRedoShortcut(keys)) {
                this.execute();
            }
        });
    }

    @Override
    public <V> void execute(ClientSessionCommand.Callback<V> callback) {
        PortablePreconditions.checkNotNull((String)"callback", callback);
        CommandResult result = null;
        if (this.redoCommandHandler.isEnabled()) {
            result = this.redoCommandHandler.execute((Object)((ClientFullSession)this.getSession()).getCanvasHandler(), this.sessionCommandManager);
            this.checkState();
        }
        callback.onSuccess();
    }

    @Override
    public AbstractClientSessionCommand<ClientFullSession> bind(ClientFullSession session) {
        super.bind((ClientSession)session);
        this.keyboardListener.bind((ClientSession)session);
        return this;
    }

    @Override
    public void unbind() {
        super.unbind();
        this.redoCommandHandler.clear();
        this.keyboardListener.unbind();
    }

    void onCommandExecuted(@Observes CanvasCommandExecutedEvent commandExecutedEvent) {
        PortablePreconditions.checkNotNull((String)"commandExecutedEvent", (Object)commandExecutedEvent);
        if (null != commandExecutedEvent.getCommand()) {
            this.redoCommandHandler.onCommandExecuted(commandExecutedEvent.getCommand());
        }
        this.checkState();
    }

    void onCommandUndoExecuted(@Observes CanvasUndoCommandExecutedEvent commandUndoExecutedEvent) {
        PortablePreconditions.checkNotNull((String)"commandUndoExecutedEvent", (Object)commandUndoExecutedEvent);
        if (null != commandUndoExecutedEvent.getCommand()) {
            this.redoCommandHandler.onUndoCommandExecuted(commandUndoExecutedEvent.getCommand());
        }
        this.checkState();
    }

    private void checkState() {
        this.setEnabled(null != this.getSession() && this.redoCommandHandler.isEnabled());
        this.fire();
    }

    private boolean isRedoShortcut(KeyboardEvent.Key ... keys) {
        return ClientKeyShortcutsHandler.isSameShortcut(keys, KeyboardEvent.Key.CONTROL, KeyboardEvent.Key.SHIFT, KeyboardEvent.Key.Z);
    }
}

