/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.command.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.service.ClientDiagramService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.client.session.ClientFullSession;
import org.kie.workbench.common.stunner.core.client.session.Session;
import org.kie.workbench.common.stunner.core.client.session.command.AbstractClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.uberfire.backend.vfs.Path;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.mvp.ParameterizedCommand;

@Dependent
public class RefreshSessionCommand
extends AbstractClientSessionCommand<ClientFullSession> {
    private static Logger LOGGER = Logger.getLogger(RefreshSessionCommand.class.getName());
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private final ClientDiagramService clientDiagramService;

    protected RefreshSessionCommand() {
        this(null, null);
    }

    @Inject
    public RefreshSessionCommand(@Session SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, ClientDiagramService clientDiagramService) {
        super(false);
        this.sessionCommandManager = sessionCommandManager;
        this.clientDiagramService = clientDiagramService;
    }

    @Override
    public <V> void execute(final ClientSessionCommand.Callback<V> callback) {
        PortablePreconditions.checkNotNull((String)"callback", callback);
        final Path path = this.getDiagramPath();
        LOGGER.log(Level.FINE, "Refreshing diagram for path [" + path + "]...");
        ((ClientFullSession)this.getSession()).getCanvasHandler().clear();
        this.sessionCommandManager.getRegistry().clear();
        this.clientDiagramService.getByPath(path, new ServiceCallback<Diagram<Graph, Metadata>>(){

            public void onSuccess(Diagram diagram) {
                LOGGER.log(Level.FINE, "Refreshing diagram for path [" + path + "]...");
                ((ClientFullSession)RefreshSessionCommand.this.getSession()).getCanvasHandler().draw(diagram, new ParameterizedCommand<CommandResult<?>>(){

                    public void execute(CommandResult<?> result) {
                        if (!CommandUtils.isError(result)) {
                            callback.onSuccess();
                        } else {
                            LOGGER.log(Level.SEVERE, "Error when drawing diagram for path [" + path + "] - [result=" + result + "]");
                            callback.onError(new ClientRuntimeError(result.toString()));
                        }
                    }
                });
            }

            public void onError(ClientRuntimeError error) {
                LOGGER.log(Level.SEVERE, "Error when loading diagram for path [" + path + "]", error.getThrowable());
                callback.onError(error);
            }
        });
        this.checkState();
    }

    private Path getDiagramPath() {
        return null != this.getSession() ? ((ClientFullSession)this.getSession()).getCanvasHandler().getDiagram().getMetadata().getPath() : null;
    }

    private void checkState() {
        this.setEnabled(this.hasSessionCommands());
        this.fire();
    }

    private boolean hasSessionCommands() {
        return null != this.getSession() && !this.sessionCommandManager.getRegistry().isEmpty();
    }
}

