/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.command.impl;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.command.CanvasCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.command.CanvasUndoCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.event.keyboard.ClientKeyShortcutsHandler;
import org.kie.workbench.common.stunner.core.client.event.keyboard.KeyboardEvent;
import org.kie.workbench.common.stunner.core.client.event.keyboard.SessionKeyShortcutsHandler;
import org.kie.workbench.common.stunner.core.client.session.ClientFullSession;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.Session;
import org.kie.workbench.common.stunner.core.client.session.command.AbstractClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.uberfire.commons.validation.PortablePreconditions;

@Dependent
public class UndoSessionCommand
extends AbstractClientSessionCommand<ClientFullSession> {
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private final SessionKeyShortcutsHandler keyboardListener;

    protected UndoSessionCommand() {
        this(null, null);
    }

    @Inject
    public UndoSessionCommand(@Session SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, SessionKeyShortcutsHandler keyboardListener) {
        super(false);
        this.sessionCommandManager = sessionCommandManager;
        this.keyboardListener = keyboardListener;
    }

    @PostConstruct
    public void init() {
        this.keyboardListener.setKeyShortcutCallback(keys -> {
            if (this.isUndoShortcut(keys)) {
                this.execute();
            }
        });
    }

    @Override
    public <V> void execute(ClientSessionCommand.Callback<V> callback) {
        PortablePreconditions.checkNotNull((String)"callback", callback);
        SessionCommandManager<AbstractCanvasHandler> scm = this.getSessionCommandManager();
        if (null != scm) {
            CommandResult result = this.getSessionCommandManager().undo((Object)((AbstractCanvasHandler)((ClientFullSession)this.getSession()).getCanvasHandler()));
            this.checkState();
            if (CommandUtils.isError((CommandResult)result)) {
                callback.onError(result);
            } else {
                callback.onSuccess();
            }
        }
    }

    @Override
    public AbstractClientSessionCommand<ClientFullSession> bind(ClientFullSession session) {
        super.bind((ClientSession)session);
        this.keyboardListener.bind((ClientSession)session);
        return this;
    }

    @Override
    public void unbind() {
        super.unbind();
        this.keyboardListener.unbind();
    }

    void onCommandExecuted(@Observes CanvasCommandExecutedEvent commandExecutedEvent) {
        PortablePreconditions.checkNotNull((String)"commandExecutedEvent", (Object)commandExecutedEvent);
        this.checkState();
    }

    void onCommandUndoExecuted(@Observes CanvasUndoCommandExecutedEvent commandUndoExecutedEvent) {
        PortablePreconditions.checkNotNull((String)"commandUndoExecutedEvent", (Object)commandUndoExecutedEvent);
        this.checkState();
    }

    private void checkState() {
        if (null != this.getSession()) {
            SessionCommandManager<AbstractCanvasHandler> cm = this.getSessionCommandManager();
            boolean isHistoryEmpty = cm == null || cm.getRegistry().getCommandHistory().isEmpty();
            this.setEnabled(!isHistoryEmpty);
        } else {
            this.setEnabled(false);
        }
        this.fire();
    }

    private SessionCommandManager<AbstractCanvasHandler> getSessionCommandManager() {
        return this.sessionCommandManager;
    }

    private boolean isUndoShortcut(KeyboardEvent.Key ... keys) {
        return ClientKeyShortcutsHandler.isSameShortcut(keys, KeyboardEvent.Key.CONTROL, KeyboardEvent.Key.Z);
    }
}

