/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.impl;

import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasControlRegistrationHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.pan.PanControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.select.SelectionControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.zoom.ZoomControl;
import org.kie.workbench.common.stunner.core.client.session.ClientReadOnlySession;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientSession;
import org.kie.workbench.common.stunner.core.graph.Element;

public abstract class AbstractClientReadOnlySession
extends AbstractClientSession
implements ClientReadOnlySession<AbstractCanvas, AbstractCanvasHandler> {
    protected SelectionControl<AbstractCanvasHandler, Element> selectionControl;
    protected ZoomControl<AbstractCanvas> zoomControl;
    protected PanControl<AbstractCanvas> panControl;
    private final CanvasControlRegistrationHandler<AbstractCanvas, AbstractCanvasHandler> registrationHandler;

    public AbstractClientReadOnlySession(AbstractCanvas canvas, AbstractCanvasHandler canvasHandler, SelectionControl<AbstractCanvasHandler, Element> selectionControl, ZoomControl<AbstractCanvas> zoomControl, PanControl<AbstractCanvas> panControl) {
        super(canvas, canvasHandler);
        this.selectionControl = selectionControl;
        this.zoomControl = zoomControl;
        this.panControl = panControl;
        this.registrationHandler = new CanvasControlRegistrationHandler<AbstractCanvas, AbstractCanvasHandler>(canvas, canvasHandler);
        this.registrationHandler.registerCanvasHandlerControl((CanvasControl<AbstractCanvasHandler>)selectionControl);
        this.registrationHandler.registerCanvasControl((CanvasControl<AbstractCanvas>)zoomControl);
        this.registrationHandler.registerCanvasControl((CanvasControl<AbstractCanvas>)panControl);
    }

    @Override
    protected void doOpen() {
        this.registrationHandler.enable();
    }

    @Override
    public void doDestroy() {
        this.registrationHandler.disable();
    }

    @Override
    protected void doPause() {
    }

    @Override
    protected void doResume() {
    }

    protected CanvasControlRegistrationHandler<AbstractCanvas, AbstractCanvasHandler> getRegistrationHandler() {
        return this.registrationHandler;
    }
}

