/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.impl;

import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.util.UUID;

public abstract class AbstractClientSession
implements ClientSession<AbstractCanvas, AbstractCanvasHandler> {
    private final transient AbstractCanvas canvas;
    private final transient AbstractCanvasHandler canvasHandler;
    private final transient String uuid = UUID.uuid();
    boolean isOpened;

    public AbstractClientSession(AbstractCanvas canvas, AbstractCanvasHandler canvasHandler) {
        this.canvas = canvas;
        this.canvasHandler = canvasHandler;
        this.isOpened = false;
    }

    protected abstract void doOpen();

    protected abstract void doPause();

    protected abstract void doResume();

    protected abstract void doDestroy();

    public void open() {
        this.doOpen();
        this.isOpened = true;
    }

    public void pause() {
        if (!this.isOpened) {
            throw new IllegalStateException("Session cannot be paused as it has been not opened yet.");
        }
        this.doPause();
    }

    public void resume() {
        if (this.isOpened) {
            this.doResume();
        }
    }

    public void destroy() {
        if (!this.isOpened) {
            throw new IllegalStateException("Session cannot be destroyed as it has been not opened.");
        }
        this.doDestroy();
        this.canvasHandler.destroy();
        this.isOpened = false;
    }

    public AbstractCanvas getCanvas() {
        return this.canvas;
    }

    public AbstractCanvasHandler getCanvasHandler() {
        return this.canvasHandler;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractClientSession)) {
            return false;
        }
        AbstractClientSession that = (AbstractClientSession)o;
        return this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return this.uuid == null ? 0 : ~(~this.uuid.hashCode());
    }

    public boolean isOpened() {
        return this.isOpened;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [uuid=" + this.uuid + "]";
    }
}

