/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape.factory;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.factory.AbstractShapeFactory;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeDefFactory;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.definition.shape.Glyph;
import org.kie.workbench.common.stunner.core.definition.shape.ShapeDef;

@Dependent
public class DelegateShapeFactory<W, S extends Shape>
extends AbstractShapeFactory<W, S> {
    private final Map<String, DefinitionTypeBindings> definitionTypeBindings = new HashMap<String, DefinitionTypeBindings>();

    public DelegateShapeFactory<W, S> delegate(Class<? extends W> definitionType, ShapeDef<? extends W> shapeDef, Supplier<? extends ShapeDefFactory> factory) {
        this.definitionTypeBindings.put(DelegateShapeFactory.getDefinitionId(definitionType), new DefinitionTypeBindings(definitionType, shapeDef, factory));
        return this;
    }

    public S newShape(W definition) {
        DefinitionTypeBindings bindings = this.getBindings(definition.getClass());
        ShapeDef shapeDef = bindings.shapeDef;
        return (S)bindings.factory.get().newShape(definition, shapeDef);
    }

    @Override
    protected Glyph getGlyphFor(String definitionId) {
        DefinitionTypeBindings bindings = this.definitionTypeBindings.get(definitionId);
        Class<?> defType = bindings.defType;
        return bindings.shapeDef.getGlyph(defType);
    }

    static String getDefinitionId(Class<?> type) {
        return BindableAdapterUtils.getDefinitionId(type);
    }

    private DefinitionTypeBindings getBindings(Class<?> type) {
        DefinitionTypeBindings bindings = this.definitionTypeBindings.get(DelegateShapeFactory.getDefinitionId(type));
        if (null == bindings) {
            throw new RuntimeException("No ShapeDefinition or ShapeFactory binding found for the Definition type [" + type + "]");
        }
        return bindings;
    }

    private class DefinitionTypeBindings {
        final Class<?> defType;
        final ShapeDef<? extends W> shapeDef;
        final Supplier<? extends ShapeDefFactory> factory;

        private DefinitionTypeBindings(Class<?> defType, ShapeDef<? extends W> shapeDef, Supplier<? extends ShapeDefFactory> factory) {
            this.defType = defType;
            this.shapeDef = shapeDef;
            this.factory = factory;
        }
    }
}

