/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape.impl;

import org.kie.workbench.common.stunner.core.client.shape.ElementShape;
import org.kie.workbench.common.stunner.core.client.shape.Lifecycle;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.client.shape.impl.ShapeDefViewHandler;
import org.kie.workbench.common.stunner.core.client.shape.impl.ShapeImpl;
import org.kie.workbench.common.stunner.core.client.shape.impl.ShapeStateHelper;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.definition.shape.MutableShapeDef;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public abstract class AbstractElementShape<W, C extends View<W>, E extends Element<C>, D extends MutableShapeDef<W>, V extends ShapeView<?>>
implements ElementShape<W, C, E, V>,
Lifecycle {
    private final ShapeImpl<V> shape;
    private final ShapeDefViewHandler<W, V, D> defViewHandler;

    protected AbstractElementShape(D shapeDef, V view) {
        this.shape = new ShapeImpl<V>(view, new ShapeStateHelper());
        this.defViewHandler = new ShapeDefViewHandler(shapeDef, view);
        this.getShape().getShapeStateHelper().forShape((Shape<V>)this);
    }

    protected AbstractElementShape(D shapeDef, V view, ShapeStateHelper<V, Shape<V>> shapeStateHelper) {
        this.shape = new ShapeImpl<V>(view, shapeStateHelper);
        this.defViewHandler = new ShapeDefViewHandler(shapeDef, view);
        this.getShape().getShapeStateHelper().forShape((Shape<V>)this);
    }

    public void setUUID(String uuid) {
        this.shape.setUUID(uuid);
    }

    public String getUUID() {
        return this.shape.getUUID();
    }

    public void applyTitle(String title, E element, MutationContext mutationContext) {
        this.getDefViewHandler().applyTitle(title, this.getDefinition((Element<? extends View<W>>)element), mutationContext);
    }

    public void beforeDraw() {
        this.shape.beforeDraw();
    }

    public void afterDraw() {
        this.shape.afterDraw();
    }

    public void applyProperties(E element, MutationContext mutationContext) {
        this.getDefViewHandler().applyProperties(this.getDefinition((Element<? extends View<W>>)element), mutationContext);
        this.getShape().getShapeStateHelper().save(state -> state.equals((Object)ShapeState.NONE) || state.equals((Object)ShapeState.SELECTED));
    }

    public V getShapeView() {
        return this.shape.getShapeView();
    }

    public void destroy() {
        this.shape.destroy();
    }

    public ShapeDefViewHandler<W, V, D> getDefViewHandler() {
        return this.defViewHandler;
    }

    public ShapeImpl<V> getShape() {
        return this.shape;
    }

    public D getShapeDefinition() {
        return this.defViewHandler.getShapeDefinition();
    }

    protected W getDefinition(Element<? extends View<W>> element) {
        return (W)((View)element.getContent()).getDefinition();
    }
}

