/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape.impl;

import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.impl.ShapeViewHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.HasTitle;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.definition.shape.MutableShapeDef;

public class ShapeDefViewHandler<W, V extends ShapeView, D extends MutableShapeDef<W>> {
    private final D shapeDefinition;
    private final ShapeViewHandler<V> viewHandler;

    public ShapeDefViewHandler(D shapeDefinition, V view) {
        this(shapeDefinition, new ShapeViewHandler<V>(view));
    }

    ShapeDefViewHandler(D shapeDefinition, ShapeViewHandler<V> viewHandler) {
        this.shapeDefinition = shapeDefinition;
        this.viewHandler = viewHandler;
    }

    public void applyProperties(W element, MutationContext mutationContext) {
        double alpha = this.getAlpha(element);
        this.viewHandler.applyAlpha(alpha, mutationContext);
        String color = this.getBackgroundColor(element);
        this.viewHandler.applyFillColor(color, mutationContext);
        double fillAlpha = this.getBackgroundAlpha(element);
        this.viewHandler.applyFillAlpha(fillAlpha, mutationContext);
        String _strokeColor = this.getBorderColor(element);
        double _strokeWidth = this.getBorderSize(element);
        this.viewHandler.applyBorders(_strokeColor, _strokeWidth, mutationContext);
        double _strokeAlpha = this.getBorderAlpha(element);
        this.viewHandler.applyBorderAlpha(_strokeAlpha, mutationContext);
    }

    public void applyTitle(String title, W element, MutationContext mutationContext) {
        this.viewHandler.applyTitle(title, mutationContext);
        this.applyFont(element, mutationContext);
    }

    public ShapeViewHandler<V> getViewHandler() {
        return this.viewHandler;
    }

    public D getShapeDefinition() {
        return this.shapeDefinition;
    }

    private void applyFont(W element, MutationContext mutationContext) {
        String family = this.getFontFamily(element);
        String fillColor = this.getFontColor(element);
        String strokeColor = this.getFontBorderColor(element);
        Double size = this.getFontSize(element);
        Double borderSize = this.getFontBorderSize(element);
        Double alpha = this.getFontAlpha(element);
        HasTitle.Position position = this.getPosition(element);
        Double rotation = this.getRotation(element);
        this.viewHandler.applyFont(family, fillColor, strokeColor, size, borderSize, alpha, position, rotation, mutationContext);
    }

    private double getAlpha(W element) {
        return this.shapeDefinition.getAlpha(element);
    }

    private String getBackgroundColor(W element) {
        return this.shapeDefinition.getBackgroundColor(element);
    }

    private double getBackgroundAlpha(W element) {
        return this.shapeDefinition.getBackgroundAlpha(element);
    }

    private String getBorderColor(W element) {
        return this.shapeDefinition.getBorderColor(element);
    }

    private double getBorderSize(W element) {
        return this.shapeDefinition.getBorderSize(element);
    }

    private double getBorderAlpha(W element) {
        return this.shapeDefinition.getBorderAlpha(element);
    }

    private String getFontFamily(W element) {
        return this.shapeDefinition.getFontFamily(element);
    }

    private String getFontColor(W element) {
        return this.shapeDefinition.getFontColor(element);
    }

    private String getFontBorderColor(W element) {
        return this.shapeDefinition.getFontBorderColor(element);
    }

    private double getFontSize(W element) {
        return this.shapeDefinition.getFontSize(element);
    }

    private double getFontAlpha(W element) {
        return 1.0;
    }

    private HasTitle.Position getPosition(W element) {
        return this.shapeDefinition.getFontPosition(element);
    }

    private double getRotation(W element) {
        return this.shapeDefinition.getFontRotation(element);
    }

    private double getFontBorderSize(W element) {
        return this.shapeDefinition.getFontBorderSize(element);
    }
}

