/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape.impl;

import org.kie.workbench.common.stunner.core.client.shape.Lifecycle;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.client.shape.impl.ShapeStateHelper;
import org.kie.workbench.common.stunner.core.client.shape.view.HasTitle;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;

public class ShapeImpl<V extends ShapeView>
implements Shape<V>,
Lifecycle {
    private final V view;
    private final ShapeStateHelper<V, Shape<V>> shapeStateHelper;
    private String uuid;

    public ShapeImpl(V view) {
        this.view = view;
        this.shapeStateHelper = new ShapeStateHelper(this);
    }

    public ShapeImpl(V view, ShapeStateHelper<V, Shape<V>> shapeStateHelper) {
        this.view = view;
        this.shapeStateHelper = shapeStateHelper;
        this.shapeStateHelper.forShape(this);
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public String getUUID() {
        return this.uuid;
    }

    public void beforeDraw() {
    }

    public void afterDraw() {
        if (this.view instanceof HasTitle) {
            ((HasTitle)this.view).moveTitleToTop();
        }
    }

    public void applyState(ShapeState shapeState) {
        this.shapeStateHelper.applyState(shapeState);
    }

    public ShapeStateHelper<V, Shape<V>> getShapeStateHelper() {
        return this.shapeStateHelper;
    }

    public V getShapeView() {
        return this.view;
    }

    public void destroy() {
        this.view.destroy();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShapeImpl)) {
            return false;
        }
        ShapeImpl that = (ShapeImpl)o;
        return this.uuid != null && this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return this.uuid == null ? 0 : ~(~this.uuid.hashCode());
    }
}

