/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape.impl;

import java.util.Optional;
import java.util.function.Predicate;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;

public class ShapeStateHelper<V extends ShapeView, S extends Shape<V>> {
    static final double ACTIVE_STROKE_WIDTH_PCT = 1.0;
    static final double ACTIVE_STROKE_ALPHA = 1.0;
    private double strokeWidth;
    private double strokeAlpha;
    private String strokeColor;
    private ShapeState state;
    private double activeStrokeWidth;
    private Optional<S> shape = Optional.empty();

    public ShapeStateHelper() {
        this.forShape(null);
    }

    public ShapeStateHelper(S shape) {
        this.forShape(shape);
    }

    public ShapeStateHelper forShape(S shape) {
        this.shape = Optional.ofNullable(shape);
        this.state = ShapeState.NONE;
        this.save(state -> true);
        return this;
    }

    public void setStrokeWidthForActiveState(double activeStrokeWidth) {
        this.activeStrokeWidth = activeStrokeWidth;
    }

    public ShapeStateHelper save(Predicate<ShapeState> stateFilter) {
        if (stateFilter.test(this.state)) {
            this.shape.ifPresent(s -> {
                this.strokeWidth = s.getShapeView().getStrokeWidth();
            });
            this.shape.ifPresent(s -> {
                this.activeStrokeWidth = this.strokeWidth + this.strokeWidth * 1.0;
            });
            this.shape.ifPresent(s -> {
                this.strokeAlpha = s.getShapeView().getStrokeAlpha();
            });
            this.shape.ifPresent(s -> {
                this.strokeColor = s.getShapeView().getStrokeColor();
            });
        }
        return this;
    }

    public ShapeStateHelper applyState(ShapeState shapeState) {
        if (!this.state.equals((Object)shapeState)) {
            this.state = shapeState;
            if (ShapeState.SELECTED.equals((Object)shapeState)) {
                this.applySelectedState();
            } else if (ShapeState.HIGHLIGHT.equals((Object)shapeState)) {
                this.applyHighlightState();
            } else if (ShapeState.INVALID.equals((Object)shapeState)) {
                this.applyInvalidState();
            } else {
                this.applyNoneState(this.strokeColor, this.strokeWidth, this.strokeAlpha);
            }
        }
        return this;
    }

    public ShapeState getState() {
        return this.state;
    }

    protected void applyActiveState(String color) {
        this.getShapeView().setStrokeColor(color);
        this.getShapeView().setStrokeWidth(this.getActiveStrokeWidth());
        this.getShapeView().setStrokeAlpha(ShapeStateHelper.getActiveStrokeAlpha());
    }

    protected void applyNoneState(String color, double width, double alpha) {
        this.getShapeView().setStrokeColor(color);
        this.getShapeView().setStrokeWidth(width);
        this.getShapeView().setStrokeAlpha(alpha);
    }

    protected S getShape() {
        return (S)((Shape)this.shape.orElseThrow(() -> new IllegalArgumentException("Shape has not been set.")));
    }

    protected double getActiveStrokeWidth() {
        return this.activeStrokeWidth;
    }

    protected static double getActiveStrokeAlpha() {
        return 1.0;
    }

    private void applySelectedState() {
        this.applyActiveState(ShapeState.SELECTED.getColor());
    }

    private void applyInvalidState() {
        this.applyActiveState(ShapeState.INVALID.getColor());
    }

    private void applyHighlightState() {
        this.applyActiveState(ShapeState.HIGHLIGHT.getColor());
    }

    private V getShapeView() {
        return (V)((Shape)this.shape.orElseThrow(() -> new IllegalArgumentException("Shape has not been set."))).getShapeView();
    }
}

