/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape.impl;

import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.view.HasFillGradient;
import org.kie.workbench.common.stunner.core.client.shape.view.HasRadius;
import org.kie.workbench.common.stunner.core.client.shape.view.HasSize;
import org.kie.workbench.common.stunner.core.client.shape.view.HasTitle;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;

public class ShapeViewHandler<V extends ShapeView> {
    private final V view;

    public ShapeViewHandler(V view) {
        this.view = view;
    }

    public void applyTitle(String title, MutationContext mutationContext) {
        if (title != null && this.getShapeView() instanceof HasTitle) {
            HasTitle hasTitle = (HasTitle)this.getShapeView();
            hasTitle.setTitle(title);
        }
    }

    public void applyAlpha(Double alpha, MutationContext mutationContext) {
        if (null != alpha) {
            this.getShapeView().setAlpha(alpha.doubleValue());
        }
    }

    public void applyFillColor(String color, MutationContext mutationContext) {
        if (color != null && color.trim().length() > 0) {
            boolean hasGradient = this.getShapeView() instanceof HasFillGradient;
            if (!hasGradient) {
                this.getShapeView().setFillColor(color);
            } else {
                ((HasFillGradient)this.getShapeView()).setFillGradient(HasFillGradient.Type.LINEAR, color, "#FFFFFF");
            }
        }
    }

    public void applyFillAlpha(Double alpha, MutationContext mutationContext) {
        if (null != alpha) {
            this.getShapeView().setFillAlpha(alpha.doubleValue());
        }
    }

    public void applyBorders(String color, Double width, MutationContext mutationContext) {
        if (color != null && color.trim().length() > 0) {
            this.getShapeView().setStrokeColor(color);
        }
        if (width != null) {
            this.getShapeView().setStrokeWidth(width.doubleValue());
        }
    }

    public void applyBorderAlpha(Double alpha, MutationContext mutationContext) {
        if (null != alpha) {
            this.getShapeView().setStrokeAlpha(alpha.doubleValue());
        }
    }

    public void applyFont(String fontFamily, String fontColor, String strokeColor, Double size, Double borderSize, Double alpha, HasTitle.Position position, Double rotationDegrees, MutationContext mutationContext) {
        HasTitle hasTitle = (HasTitle)this.getShapeView();
        if (fontFamily != null && fontFamily.trim().length() > 0) {
            hasTitle.setTitleFontFamily(fontFamily);
        }
        if (fontColor != null && fontColor.trim().length() > 0) {
            hasTitle.setTitleFontColor(fontColor);
        }
        if (strokeColor != null && strokeColor.trim().length() > 0) {
            hasTitle.setTitleStrokeColor(strokeColor);
        }
        if (size != null && size > 0.0) {
            hasTitle.setTitleFontSize(size.doubleValue());
        }
        if (borderSize != null && borderSize > 0.0) {
            hasTitle.setTitleStrokeWidth(borderSize.doubleValue());
        }
        if (null != alpha) {
            hasTitle.setTitleAlpha(alpha.doubleValue());
        }
        if (null != position) {
            hasTitle.setTitlePosition(position);
        }
        if (null != rotationDegrees) {
            hasTitle.setTitleRotation(rotationDegrees.doubleValue());
        }
    }

    public void applySize(double width, double height, MutationContext mutationContext) {
        ((HasSize)this.getShapeView()).setSize(width, height);
    }

    public void applyRadius(double radius, MutationContext mutationContext) {
        if (radius > 0.0) {
            ((HasRadius)this.getShapeView()).setRadius(radius);
        }
    }

    public V getShapeView() {
        return this.view;
    }
}

