/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.util;

import com.google.gwt.core.client.GWT;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.shape.EdgeShape;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.AbstractChildrenTraverseCallback;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.ChildrenTraverseProcessorImpl;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeWalkTraverseProcessor;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeWalkTraverseProcessorImpl;

public class ShapeUtils {
    public static String getModuleAbsolutePath(String path) {
        return GWT.getModuleBaseURL() + path;
    }

    public static void applyConnections(Edge<?, ?> edge, CanvasHandler canvasHandler, MutationContext mutationContext) {
        Canvas canvas = canvasHandler.getCanvas();
        Node sourceNode = edge.getSourceNode();
        Node targetNode = edge.getTargetNode();
        Shape source = sourceNode != null ? canvas.getShape(sourceNode.getUUID()) : null;
        Shape target = targetNode != null ? canvas.getShape(targetNode.getUUID()) : null;
        EdgeShape connector = (EdgeShape)canvas.getShape(edge.getUUID());
        connector.applyConnections(edge, source != null ? source.getShapeView() : null, target != null ? target.getShapeView() : null, mutationContext);
    }

    public static void moveViewConnectorsToTop(AbstractCanvasHandler canvasHandler, Node<?, Edge> node) {
        final HashSet<String> connectorIds = new HashSet<String>();
        ShapeUtils.appendViewConnectorIds(connectorIds, node);
        new ChildrenTraverseProcessorImpl((TreeWalkTraverseProcessor)new TreeWalkTraverseProcessorImpl()).setRootUUID(node.getUUID()).traverse((Object)canvasHandler.getGraphIndex().getGraph(), (Object)new AbstractChildrenTraverseCallback<Node<View, Edge>, Edge<Child, Node>>(){

            public boolean startNodeTraversal(List<Node<View, Edge>> parents, Node<View, Edge> childNode) {
                ShapeUtils.appendViewConnectorIds(connectorIds, childNode);
                return true;
            }
        });
        connectorIds.stream().forEach(id -> ShapeUtils.moveShapeToTop(canvasHandler, id));
    }

    public static double dist(double x0, double y0, double x1, double y1) {
        double dx = Math.abs(x1 - x0);
        double dy = Math.abs(y1 - y0);
        return Math.sqrt(dx * dx + dy * dy);
    }

    private static void appendViewConnectorIds(Set<String> result, Node<?, Edge> node) {
        Stream.concat(node.getInEdges().stream(), node.getOutEdges().stream()).filter(e -> e.getContent() instanceof ViewConnector).forEach(e -> result.add(e.getUUID()));
    }

    private static void moveShapeToTop(AbstractCanvasHandler canvasHandler, String uuid) {
        Shape shape = canvasHandler.getCanvas().getShape(uuid);
        if (null != shape) {
            shape.getShapeView().moveToTop();
        }
    }
}

