/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.util;

import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.safehtml.shared.UriUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.errai.common.client.util.Base64Util;

@ApplicationScoped
public class SvgDataUriGenerator {
    public static final String SVG_CONTENT_TYPE = "image/svg+xml";
    public static final String SVG_DATA_URI_BASE64 = "data:image/svg+xml;base64,";
    public static final String SVG_DATA_URI_UTF8 = "data:image/svg+xml;utf8,";
    static final String SVG_OPEN_TAG = "<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" %1s>\n";
    private static final String SVG_CLOSE_TAG = "</svg>";
    private static final String DEFS_OPEN_TAG = "<defs>";
    private static final String DEFS_CLOSE_TAG = "</defs>";
    private static final RegExp HREF_FILENAME_PATTERN = RegExp.compile((String)".*xlink:href=\"(.*\\.svg).*");
    private static final RegExp VIEWBOX_PATTERN = RegExp.compile((String)".*viewBox=\"(.*)\".*");
    private static final RegExp USE_TAG_PATTERN = RegExp.compile((String)"<use.*xlink:href.*/>");
    private static final RegExp USE_TAG_REFID_PATTERN = RegExp.compile((String)".*xlink:href=\".*\\#(.*)\".*");
    private static final RegExp XML_TAG_PATTERN = RegExp.compile((String)"<\\?xml.*\\?>");

    public static String encodeUtf8(String dataUriDecoded) {
        return SVG_DATA_URI_UTF8 + UriUtils.encode((String)dataUriDecoded).replace("#", "%23");
    }

    public static String encodeBase64(String dataUriDecoded) {
        return SVG_DATA_URI_BASE64 + Base64Util.encode((byte[])dataUriDecoded.getBytes(), (int)0, (int)dataUriDecoded.length());
    }

    public String generate(SafeUri svgUri) {
        return this.generate(svgUri, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    }

    public String generate(SafeUri svgUri, Collection<SafeUri> svgDefs, Collection<String> validUseRefIds) {
        String mainContent = SvgDataUriGenerator.getSVGContent(svgUri.asString(), new SVGGeneratorOptions(true, validUseRefIds.isEmpty(), viewName -> !validUseRefIds.contains(viewName), true));
        if (!svgDefs.isEmpty()) {
            String childrenContent = SvgDataUriGenerator.getChildrenSVGContent(svgDefs, new SVGGeneratorOptions(true, true, false));
            String defs = DEFS_OPEN_TAG + childrenContent + DEFS_CLOSE_TAG;
            String svgOpenTag = SVG_OPEN_TAG.replaceAll("\\%1s", this.generateSVGSizeAttributesToAppend(mainContent));
            return svgOpenTag + mainContent + defs + SVG_CLOSE_TAG;
        }
        return mainContent;
    }

    private static String getChildrenSVGContent(Collection<SafeUri> uris, SVGGeneratorOptions options) {
        return uris.stream().map(uriStream -> SvgDataUriGenerator.getSVGContent(uriStream.asString(), options)).collect(Collectors.joining(" "));
    }

    private static String getSVGContent(String dataUriEncodedContent, SVGGeneratorOptions options) {
        SVGContentType type = SvgDataUriGenerator.getType(dataUriEncodedContent);
        String s = dataUriEncodedContent.substring(type.getLength());
        if (SVGContentType.XML_BASE64.equals((Object)type)) {
            s = new String(Base64Util.decode((String)s));
        }
        if (options.removeXmlTag) {
            s = SvgDataUriGenerator.removeXmlTag(s);
        }
        s = options.removeUseTags ? SvgDataUriGenerator.removeAllUseTags(s) : SvgDataUriGenerator.removeUseTagsById(s, options.isRemoveUseForView);
        if (options.removeHrefFileNames) {
            s = SvgDataUriGenerator.removeAllHrefFileName(s);
        }
        return s;
    }

    private static String removeXmlTag(String content) {
        return SvgDataUriGenerator.removeAll(XML_TAG_PATTERN, 0, content);
    }

    private static String removeAllUseTags(String content) {
        return SvgDataUriGenerator.removeAll(USE_TAG_PATTERN, 0, content);
    }

    private static String removeAllHrefFileName(String content) {
        return SvgDataUriGenerator.removeAll(HREF_FILENAME_PATTERN, 1, content);
    }

    private static String removeAll(RegExp exp, int group, String content) {
        String result = content;
        while (exp.test(result)) {
            MatchResult matchResult = exp.exec(result);
            if (matchResult == null) continue;
            String toReplace = matchResult.getGroup(group);
            result = result.replace(toReplace, "");
        }
        return result;
    }

    private static String removeUseTagsById(String content, Predicate<String> isRemove) {
        String result = content;
        String temp = content;
        while (USE_TAG_REFID_PATTERN.test(temp)) {
            MatchResult matchResult = USE_TAG_REFID_PATTERN.exec(temp);
            if (matchResult == null) continue;
            String id = matchResult.getGroup(1);
            if (isRemove.test(id)) {
                result = result.replace(matchResult.getGroup(0), "");
            }
            temp = temp.substring(matchResult.getIndex() + id.length());
        }
        return result;
    }

    private String generateSVGSizeAttributesToAppend(String mainContent) {
        String[] bb = this.parseViewBox(mainContent);
        if (null != bb) {
            return "width=\"" + bb[2] + "\" height=\"" + bb[3] + "\" viewBox=\"" + bb[0] + " " + bb[1] + " " + bb[2] + " " + bb[3] + "\" ";
        }
        return "";
    }

    private String[] parseViewBox(String raw) {
        MatchResult result = VIEWBOX_PATTERN.exec(raw);
        if (null != result && result.getGroupCount() == 2) {
            String bbRaw = result.getGroup(1);
            return bbRaw.split(" ");
        }
        return null;
    }

    private static SVGContentType getType(String s) {
        if (s.startsWith(SVG_DATA_URI_BASE64)) {
            return SVGContentType.XML_BASE64;
        }
        if (s.startsWith(SVG_DATA_URI_UTF8)) {
            return SVGContentType.XML_UTF8;
        }
        throw new IllegalArgumentException("The image data-uri specified is not a valid SVG data for being emedded into the DOM.");
    }

    private static final class SVGGeneratorOptions {
        private final boolean removeXmlTag;
        private final boolean removeUseTags;
        private final Predicate<String> isRemoveUseForView;
        private final boolean removeHrefFileNames;

        public SVGGeneratorOptions(boolean removeXmlTag, boolean removeUseTags, boolean removeHrefFileNames) {
            this.removeXmlTag = removeXmlTag;
            this.removeUseTags = removeUseTags;
            this.isRemoveUseForView = viewName -> true;
            this.removeHrefFileNames = removeHrefFileNames;
        }

        public SVGGeneratorOptions(boolean removeXmlTag, boolean removeUseTags, Predicate<String> isRemoveUseForView, boolean removeHrefFileNames) {
            this.removeXmlTag = removeXmlTag;
            this.removeUseTags = removeUseTags;
            this.isRemoveUseForView = isRemoveUseForView;
            this.removeHrefFileNames = removeHrefFileNames;
        }
    }

    private static enum SVGContentType {
        XML_BASE64(26),
        XML_UTF8(24);

        private final int length;

        private SVGContentType(int length) {
            this.length = length;
        }

        public int getLength() {
            return this.length;
        }
    }
}

