/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import java.util.Arrays;
import java.util.stream.Stream;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddCanvasControlPointCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.util.ControlPointValidations;

public class UpdateCanvasControlPointPositionCommand
extends AbstractCanvasCommand {
    private final Edge edge;
    private final ControlPoint[] controlPoints;
    private ControlPoint[] oldControlPoints;

    public UpdateCanvasControlPointPositionCommand(Edge edge, ControlPoint[] controlPoints) {
        this.edge = edge;
        this.controlPoints = controlPoints;
        this.oldControlPoints = (ControlPoint[])Stream.of(AddCanvasControlPointCommand.getControlPoints(edge)).map(ControlPoint::copy).toArray(ControlPoint[]::new);
    }

    @Override
    public CommandResult<CanvasViolation> allow(AbstractCanvasHandler context) {
        ControlPointValidations.checkUpdateControlPoint((ControlPoint[])AddCanvasControlPointCommand.getControlPoints(this.edge), (ControlPoint[])this.controlPoints);
        return CanvasCommandResultBuilder.SUCCESS;
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        this.allow(context);
        AddCanvasControlPointCommand.consumeControlPoints(context, this.edge, view -> view.updateControlPoints(this.controlPoints));
        return this.buildResult();
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        return new UpdateCanvasControlPointPositionCommand(this.edge, this.oldControlPoints).execute(context);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [edge=" + UpdateCanvasControlPointPositionCommand.toUUID(this.edge) + ",controlPoints=" + Arrays.toString(this.controlPoints) + "]";
    }
}

