/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCompositeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DockNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.RemoveChildrenCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.SetChildrenCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.UnDockNodeCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.impl.AbstractCompositeCommand;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Dock;

public class UpdateChildrenCommand
extends AbstractCanvasCompositeCommand {
    private final Node parent;
    private final Collection<Node> candidates;

    public UpdateChildrenCommand(Node parent, Collection<Node> candidates) {
        this.parent = parent;
        this.candidates = candidates;
    }

    public UpdateChildrenCommand(Node parent, Node candidate) {
        this.parent = parent;
        this.candidates = Collections.singleton(candidate);
    }

    private void processCandidate(Context context, Node candidate) {
        List candidateInEdges = candidate.getInEdges();
        List candidateOutEdges = candidate.getOutEdges();
        Optional<Edge> currentParentEdge = candidateInEdges.stream().filter(this.isDifferentParent()).findAny();
        Optional<Edge> currentDockEdge = candidateInEdges.stream().filter(e -> e.getContent() instanceof Dock).findAny();
        Set<Edge> dockedParentEdges = candidateOutEdges.stream().filter(e -> e.getContent() instanceof Dock).map(Edge::getTargetNode).flatMap(node -> node.getInEdges().stream()).filter(this.isDifferentParent()).collect(Collectors.toSet());
        currentDockEdge.ifPresent(e -> context.undock((Element)e.getSourceNode(), (Element)candidate));
        currentParentEdge.ifPresent(e -> context.removeChild((Element)e.getSourceNode(), (Element)candidate));
        currentParentEdge.ifPresent(e -> context.addChild((Element)this.parent, (Element)candidate));
        dockedParentEdges.forEach(e -> {
            context.removeChild((Element)e.getSourceNode(), (Element)e.getTargetNode());
            context.undock((Element)candidate, (Element)e.getTargetNode());
            context.addChild((Element)this.parent, (Element)e.getTargetNode());
            context.dock((Element)candidate, (Element)e.getTargetNode());
        });
    }

    protected AbstractCompositeCommand<AbstractCanvasHandler, CanvasViolation> initialize(AbstractCanvasHandler canvasHandler) {
        super.initialize((Object)canvasHandler);
        Context context = new Context();
        this.candidates.forEach(candidate -> this.processCandidate(context, (Node)candidate));
        UpdateChildrenCommand.consumeDockingMap(canvasHandler, context.undocked, (parent, child) -> this.addCommand((Command)new UnDockNodeCommand((Node)parent, (Node)child)));
        UpdateChildrenCommand.consumeChildrenMap(canvasHandler, context.removedChildren, (parent, children) -> this.addCommand((Command)new RemoveChildrenCommand((Node)parent, (Collection<Node<?, Edge>>)children)));
        UpdateChildrenCommand.consumeChildrenMap(canvasHandler, context.addedChildren, (parent, children) -> this.addCommand((Command)new SetChildrenCommand((Node)parent, (Collection<Node<?, Edge>>)children)));
        UpdateChildrenCommand.consumeDockingMap(canvasHandler, context.docked, (parent, child) -> this.addCommand((Command)new DockNodeCommand((Node)parent, (Node)child)));
        return this;
    }

    private Predicate<Edge> isDifferentParent() {
        return e -> e.getContent() instanceof Child && !this.parent.equals(e.getSourceNode());
    }

    public Node getParent() {
        return this.parent;
    }

    public Collection<Node> getCandidates() {
        return this.candidates;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " [parent=" + AbstractCanvasCommand.toUUID(this.parent) + ",candidates=" + AbstractCanvasCommand.toUUIDs(this.candidates) + "]";
    }

    private static void consumeChildrenMap(AbstractCanvasHandler canvasHandler, Map<String, Collection<String>> map, BiConsumer<Node, Collection<Node<?, Edge>>> consumer) {
        map.entrySet().forEach(entry -> consumer.accept(UpdateChildrenCommand.toNode(canvasHandler, (String)entry.getKey()), UpdateChildrenCommand.toNodes(canvasHandler, (Collection)entry.getValue())));
    }

    private static void consumeDockingMap(AbstractCanvasHandler canvasHandler, Map<String, String> map, BiConsumer<Node, Node> consumer) {
        map.entrySet().forEach(entry -> consumer.accept(UpdateChildrenCommand.toNode(canvasHandler, (String)entry.getValue()), UpdateChildrenCommand.toNode(canvasHandler, (String)entry.getKey())));
    }

    private static void updateChildren(Map<String, Collection<String>> map, Element parent, Element child) {
        String parentUUID = parent.getUUID();
        String childUUID = child.getUUID();
        Collection<String> children = map.get(parentUUID);
        if (null == children) {
            children = new ArrayList<String>();
            map.put(parentUUID, children);
        }
        children.add(childUUID);
    }

    private static Node toNode(AbstractCanvasHandler canvasHandler, String id) {
        return canvasHandler.getGraphIndex().getNode(id);
    }

    private static Collection<Node<?, Edge>> toNodes(AbstractCanvasHandler canvasHandler, Collection<String> uuids) {
        List<Node<?, Edge>> collected = uuids.stream().map(uuid -> UpdateChildrenCommand.toNode(canvasHandler, uuid)).collect(Collectors.toList());
        return collected;
    }

    private static class Context {
        private final Map<String, Collection<String>> addedChildren = new HashMap<String, Collection<String>>();
        private final Map<String, Collection<String>> removedChildren = new HashMap<String, Collection<String>>();
        private final Map<String, String> docked = new HashMap<String, String>();
        private final Map<String, String> undocked = new HashMap<String, String>();

        private Context() {
        }

        private void addChild(Element parent, Element child) {
            UpdateChildrenCommand.updateChildren(this.addedChildren, parent, child);
        }

        private void removeChild(Element parent, Element child) {
            UpdateChildrenCommand.updateChildren(this.removedChildren, parent, child);
        }

        private void dock(Element parent, Element child) {
            this.docked.put(child.getUUID(), parent.getUUID());
        }

        private void undock(Element parent, Element child) {
            this.undocked.put(child.getUUID(), parent.getUUID());
        }
    }
}

