/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.ToolboxControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.ToolboxControlImpl;
import org.kie.workbench.common.stunner.core.client.canvas.event.AbstractCanvasHandlerEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.AbstractCanvasShapeEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasShapeRemovedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasClearSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.client.components.toolbox.Toolbox;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ActionsToolboxFactory;
import org.kie.workbench.common.stunner.core.graph.Element;

public abstract class AbstractToolboxControl
implements ToolboxControl<AbstractCanvasHandler, Element> {
    private final ToolboxControlImpl<ActionsToolboxFactory> toolboxControl;
    private final SingleItemSelectedShowPredicate toolboxShowPredicate = new SingleItemSelectedShowPredicate();
    private String lastSelected = "";

    protected abstract List<ActionsToolboxFactory> getFactories();

    @Inject
    public AbstractToolboxControl() {
        this.toolboxControl = new ToolboxControlImpl(this::getFactories, this.toolboxShowPredicate);
    }

    AbstractToolboxControl(ToolboxControlImpl<ActionsToolboxFactory> toolboxControl) {
        this.toolboxControl = toolboxControl;
    }

    public void init(AbstractCanvasHandler context) {
        this.toolboxControl.init(context);
    }

    public void register(Element element) {
        this.toolboxControl.register(element);
    }

    public void deregister(Element element) {
        this.toolboxControl.deregister(element);
    }

    public Iterator<Toolbox<?>> getToolboxes(Element element) {
        return this.toolboxControl.getToolboxes(element);
    }

    void onCanvasSelectionEvent(@Observes CanvasSelectionEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        this.handleCanvasSelectionEvent(event);
    }

    void onCanvasClearSelectionEvent(@Observes CanvasClearSelectionEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        this.handleCanvasClearSelectionEvent(event);
    }

    void onCanvasShapeRemovedEvent(@Observes CanvasShapeRemovedEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        this.handleCanvasShapeRemovedEvent(event);
    }

    protected void handleCanvasSelectionEvent(CanvasSelectionEvent event) {
        if (this.checkEventContext((AbstractCanvasHandlerEvent)event)) {
            if (1 == event.getIdentifiers().size()) {
                String uuid = (String)event.getIdentifiers().iterator().next();
                if (this.lastSelected.equals(uuid)) {
                    return;
                }
                this.lastSelected = uuid;
                this.show(uuid);
            } else {
                this.showMultiple(event.getIdentifiers());
            }
        }
    }

    protected void handleCanvasClearSelectionEvent(CanvasClearSelectionEvent event) {
        if (this.checkEventContext((AbstractCanvasHandlerEvent)event)) {
            this.toolboxControl.destroyToolboxes();
            this.lastSelected = "";
            this.clear();
        }
    }

    protected void handleCanvasShapeRemovedEvent(CanvasShapeRemovedEvent event) {
        if (this.checkEventContext((AbstractCanvasShapeEvent)event)) {
            this.lastSelected = "";
            this.clear();
        }
    }

    private void show(String uuid) {
        this.clear();
        this.toolboxShowPredicate.id = uuid;
        this.toolboxShowPredicate.count = 1;
        this.toolboxControl.show(uuid);
    }

    private void showMultiple(Collection<String> ids) {
        this.clear();
        this.toolboxShowPredicate.id = ids.iterator().next();
        this.toolboxShowPredicate.count = ids.size();
    }

    public void clear() {
        this.toolboxControl.hideAndDestroyToolboxes();
        this.toolboxShowPredicate.id = null;
        this.toolboxShowPredicate.count = 0;
    }

    public void destroy() {
        this.clear();
        this.toolboxControl.destroy();
    }

    private boolean checkEventContext(AbstractCanvasHandlerEvent canvasHandlerEvent) {
        CanvasHandler _canvasHandler = canvasHandlerEvent.getCanvasHandler();
        return this.toolboxControl.getCanvasHandler() != null && this.toolboxControl.getCanvasHandler().equals(_canvasHandler);
    }

    private boolean checkEventContext(AbstractCanvasShapeEvent canvasShapeEvent) {
        return this.toolboxControl.getCanvasHandler() != null && this.toolboxControl.getCanvasHandler().getCanvas().equals(canvasShapeEvent.getCanvas()) && this.toolboxControl.isActive(canvasShapeEvent.getShape().getUUID());
    }

    private static class SingleItemSelectedShowPredicate
    implements Predicate<String> {
        private String id;
        private int count;

        private SingleItemSelectedShowPredicate() {
        }

        @Override
        public boolean test(String s) {
            return null == this.id && this.count == 0 || null != this.id && this.count == 1 && this.id.equals(s);
        }
    }
}

