/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.toolbox.actions;

import java.util.function.Predicate;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasClearSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasLayoutUtils;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ToolboxAction;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.resources.StunnerCommonIconsGlyphFactory;
import org.kie.workbench.common.stunner.core.client.session.Session;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickEvent;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.definition.shape.Glyph;
import org.kie.workbench.common.stunner.core.graph.Node;

@Dependent
@Default
public class DeleteNodeToolboxAction
implements ToolboxAction<AbstractCanvasHandler> {
    private final ClientTranslationService translationService;
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private final CanvasCommandFactory<AbstractCanvasHandler> commandFactory;
    private final Predicate<DeleteNodeToolboxAction> confirmDelete;
    private final Event<CanvasClearSelectionEvent> clearSelectionEvent;

    @Inject
    public DeleteNodeToolboxAction(ClientTranslationService translationService, @Session SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, CanvasCommandFactory<AbstractCanvasHandler> commandFactory, Event<CanvasClearSelectionEvent> clearSelectionEvent) {
        this(translationService, sessionCommandManager, commandFactory, deleteNodeAction -> true, clearSelectionEvent);
    }

    DeleteNodeToolboxAction(ClientTranslationService translationService, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, CanvasCommandFactory<AbstractCanvasHandler> commandFactory, Predicate<DeleteNodeToolboxAction> confirmDelete, Event<CanvasClearSelectionEvent> clearSelectionEvent) {
        this.translationService = translationService;
        this.sessionCommandManager = sessionCommandManager;
        this.commandFactory = commandFactory;
        this.confirmDelete = confirmDelete;
        this.clearSelectionEvent = clearSelectionEvent;
    }

    @Override
    public Glyph getGlyph(AbstractCanvasHandler canvasHandler, String uuid) {
        return StunnerCommonIconsGlyphFactory.DELETE;
    }

    @Override
    public String getTitle(AbstractCanvasHandler canvasHandler, String uuid) {
        return this.translationService.getValue("org.kie.workbench.common.stunner.core.delete");
    }

    @Override
    public ToolboxAction<AbstractCanvasHandler> onMouseClick(AbstractCanvasHandler canvasHandler, String uuid, MouseClickEvent event) {
        if (this.confirmDelete.test(this)) {
            Node node = CanvasLayoutUtils.getElement(canvasHandler, uuid).asNode();
            this.clearSelectionEvent.fire((Object)new CanvasClearSelectionEvent((CanvasHandler)canvasHandler));
            this.sessionCommandManager.execute((Object)canvasHandler, (Command)this.commandFactory.deleteNode(node));
        }
        return this;
    }
}

