/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.toolbox.actions;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasClearSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasLayoutUtils;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.AbstractToolboxAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ToolboxAction;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.session.Session;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickEvent;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.definition.morph.MorphDefinition;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.core.util.HashUtil;

@Dependent
public class MorphNodeToolboxAction
extends AbstractToolboxAction {
    private static Logger LOGGER = Logger.getLogger(MorphNodeToolboxAction.class.getName());
    static final String KEY_TITLE = "org.kie.workbench.common.stunner.core.client.toolbox.morphInto";
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private final CanvasCommandFactory<AbstractCanvasHandler> commandFactory;
    private final Event<CanvasSelectionEvent> selectionEvent;
    private final Event<CanvasClearSelectionEvent> clearSelectionEventEvent;
    private MorphDefinition morphDefinition;
    private String targetDefinitionId;

    @Inject
    public MorphNodeToolboxAction(DefinitionUtils definitionUtils, @Session SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, CanvasCommandFactory<AbstractCanvasHandler> commandFactory, ClientTranslationService translationService, Event<CanvasSelectionEvent> selectionEvent, Event<CanvasClearSelectionEvent> clearSelectionEventEvent) {
        super(definitionUtils, translationService);
        this.sessionCommandManager = sessionCommandManager;
        this.commandFactory = commandFactory;
        this.selectionEvent = selectionEvent;
        this.clearSelectionEventEvent = clearSelectionEventEvent;
    }

    public MorphNodeToolboxAction setMorphDefinition(MorphDefinition morphDefinition) {
        this.morphDefinition = morphDefinition;
        return this;
    }

    public MorphNodeToolboxAction setTargetDefinitionId(String targetDefinitionId) {
        this.targetDefinitionId = targetDefinitionId;
        return this;
    }

    @Override
    public ToolboxAction<AbstractCanvasHandler> onMouseClick(AbstractCanvasHandler canvasHandler, String uuid, MouseClickEvent event) {
        String ssid = canvasHandler.getDiagram().getMetadata().getShapeSetId();
        Node sourceNode = CanvasLayoutUtils.getElement(canvasHandler, uuid).asNode();
        this.clearSelectionEventEvent.fire((Object)new CanvasClearSelectionEvent((CanvasHandler)canvasHandler));
        CommandResult result = this.sessionCommandManager.execute((Object)canvasHandler, (Command)this.commandFactory.morphNode(sourceNode, this.morphDefinition, this.targetDefinitionId, ssid));
        if (CommandUtils.isError((CommandResult)result)) {
            LOGGER.log(Level.SEVERE, result.toString());
        } else {
            CanvasLayoutUtils.fireElementSelectedEvent(this.selectionEvent, canvasHandler, uuid);
        }
        return this;
    }

    @Override
    protected String getTitleKey(AbstractCanvasHandler canvasHandler, String uuid) {
        return KEY_TITLE;
    }

    @Override
    protected String getTitleDefinitionId(AbstractCanvasHandler canvasHandler, String uuid) {
        return this.targetDefinitionId;
    }

    @Override
    protected String getGlyphId(AbstractCanvasHandler canvasHandler, String uuid) {
        return this.targetDefinitionId;
    }

    @PreDestroy
    public void destroy() {
        this.morphDefinition = null;
        this.targetDefinitionId = null;
    }

    public int hashCode() {
        return HashUtil.combineHashCodes((int[])new int[]{this.morphDefinition.hashCode(), this.targetDefinitionId.hashCode()});
    }

    public boolean equals(Object o) {
        if (o instanceof MorphNodeToolboxAction) {
            MorphNodeToolboxAction other = (MorphNodeToolboxAction)o;
            return other.morphDefinition.equals(this.morphDefinition) && other.targetDefinitionId.equals(this.targetDefinitionId);
        }
        return false;
    }
}

