/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.preferences;

import java.lang.annotation.Annotation;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.core.client.preferences.StunnerPreferencesRegistryHolder;
import org.kie.workbench.common.stunner.core.client.preferences.StunnerTextPreferences;
import org.kie.workbench.common.stunner.core.client.session.impl.InstanceUtils;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.preferences.StunnerPreferences;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.uberfire.mvp.ParameterizedCommand;

@ApplicationScoped
public class StunnerPreferencesRegistryLoader {
    private final DefinitionUtils definitionUtils;
    private final ManagedInstance<StunnerPreferencesRegistryHolder> preferencesHolders;
    private final StunnerPreferences preferences;
    private final StunnerTextPreferences textPreferences;

    @Inject
    public StunnerPreferencesRegistryLoader(DefinitionUtils definitionUtils, @Any ManagedInstance<StunnerPreferencesRegistryHolder> preferencesHolders, StunnerPreferences preferences, StunnerTextPreferences textPreferences) {
        this.definitionUtils = definitionUtils;
        this.preferencesHolders = preferencesHolders;
        this.preferences = preferences;
        this.textPreferences = textPreferences;
    }

    public void load(Metadata metadata, ParameterizedCommand<StunnerPreferences> loadCompleteCallback, ParameterizedCommand<Throwable> errorCallback) {
        String definitionSetId = metadata.getDefinitionSetId();
        Annotation qualifier = this.definitionUtils.getQualifier(definitionSetId);
        StunnerPreferencesRegistryHolder holder = InstanceUtils.lookup(this.preferencesHolders, qualifier);
        this.preferences.load(prefs -> {
            holder.set(prefs, StunnerPreferences.class);
            holder.set(this.textPreferences, StunnerTextPreferences.class);
            loadCompleteCallback.execute(prefs);
        }, errorCallback);
    }

    @PreDestroy
    public void destroy() {
        this.preferencesHolders.destroyAll();
    }
}

