/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.command;

import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.appformer.client.stateControl.registry.DefaultRegistry;
import org.appformer.client.stateControl.registry.Registry;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.RegisterChangedEvent;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandManager;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;

@Dependent
public class RedoCommandHandler<C extends Command> {
    private final DefaultRegistry<C> registry;
    private final Event<RegisterChangedEvent> registerChangedEvent;

    protected RedoCommandHandler() {
        this(null, null);
    }

    @Inject
    public RedoCommandHandler(DefaultRegistry<C> registry, Event<RegisterChangedEvent> registerChangedEvent) {
        this.registry = registry;
        this.registerChangedEvent = registerChangedEvent;
    }

    public boolean onUndoCommandExecuted(C command) {
        this.registry.register(command);
        return this.isEnabled();
    }

    public boolean onCommandExecuted(C command) {
        if (this.isEnabled()) {
            Command last = (Command)this.registry.peek();
            if (last.equals(command)) {
                this.registry.pop();
            } else {
                this.clear();
            }
        }
        return this.isEnabled();
    }

    public CommandResult<?> execute(Object context, CommandManager commandManager) {
        if (this.registry.isEmpty()) {
            return GraphCommandResultBuilder.SUCCESS;
        }
        Command last = (Command)this.registry.peek();
        return commandManager.execute(context, last);
    }

    public void setSession(ClientSession clientSession) {
        this.registry.setRegistryChangeListener(() -> this.registerChangedEvent.fire((Object)new RegisterChangedEvent(clientSession.getCanvasHandler())));
    }

    public boolean isEnabled() {
        return !this.registry.isEmpty();
    }

    public void clear() {
        this.registry.clear();
    }

    protected Registry<C> getRegistry() {
        return this.registry;
    }
}

